/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.services.authentication;

import javax.naming.AuthenticationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.core.services.authentication.AbstractAuthenticator;
import org.wso2.carbon.core.util.AnonymousSessionUtil;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;

public class AuthenticatorHelper {
    private static final Log log = LogFactory.getLog(AbstractAuthenticator.class);

    public static UserRealm getUserRealm(int tenantId, RealmService realmService, RegistryService registryService) throws AuthenticationException {
        if (realmService == null || registryService == null) {
            return null;
        }
        try {
            String tenantDomain = realmService.getTenantManager().getDomain(tenantId);
            return AnonymousSessionUtil.getRealmByTenantDomain((RegistryService)registryService, (RealmService)realmService, (String)tenantDomain);
        }
        catch (UserStoreException e) {
            String msg = "Unable to retrieve tenant domain for tenant id " + tenantId;
            log.error((Object)msg, (Throwable)e);
        }
        catch (CarbonException e) {
            log.error((Object)("Unable to retrieve realm for tenant id " + tenantId), (Throwable)e);
        }
        return null;
    }
}

