/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.module.mediarss.types;

import com.sun.syndication.feed.impl.EqualsBean;
import com.sun.syndication.feed.impl.ToStringBean;

public class Restriction {
    private Relationship relationship;
    private String value;
    private Type type;

    public Restriction(Relationship relationship, Type type, String value) {
        if (value == null || relationship == null) {
            throw new NullPointerException("Value and Relationship cannot be null.");
        }
        if (type == null && !value.equals("all") && !value.equals("none")) {
            throw new NullPointerException("Type is required if the value is other than 'all' or 'none'.");
        }
        this.relationship = relationship;
        this.type = type;
        this.value = value;
    }

    public Relationship getRelationship() {
        return this.relationship;
    }

    public Type getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        EqualsBean eBean = new EqualsBean(this.getClass(), this);
        return eBean.beanEquals(obj);
    }

    public int hashCode() {
        EqualsBean equals = new EqualsBean(this.getClass(), this);
        return equals.beanHashCode();
    }

    public String toString() {
        ToStringBean tsBean = new ToStringBean(this.getClass(), this);
        return tsBean.toString();
    }

    public static class Type {
        public static final Type COUNTRY = new Type("country");
        public static final Type URI = new Type("uri");
        private String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class Relationship {
        public static final Relationship ALLOW = new Relationship("allow");
        public static final Relationship DENY = new Relationship("deny");
        private String value;

        private Relationship(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

