/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jaqu;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.jaqu.Db;

public class SQLStatement {
    private Db db;
    private StringBuilder buff = new StringBuilder();
    private String sql;
    private ArrayList<Object> params = new ArrayList();

    SQLStatement(Db db) {
        this.db = db;
    }

    void setSQL(String string) {
        this.sql = string;
        this.buff = new StringBuilder(string);
    }

    public SQLStatement appendSQL(String string) {
        this.buff.append(string);
        this.sql = null;
        return this;
    }

    String getSQL() {
        if (this.sql == null) {
            this.sql = this.buff.toString();
        }
        return this.sql;
    }

    SQLStatement addParameter(Object object) {
        this.params.add(object);
        return this;
    }

    ResultSet executeQuery() {
        try {
            return this.prepare().executeQuery();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    int executeUpdate() {
        try {
            return this.prepare().executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    private void setValue(PreparedStatement preparedStatement, int n, Object object) {
        try {
            preparedStatement.setObject(n, object);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    private PreparedStatement prepare() {
        PreparedStatement preparedStatement = this.db.prepare(this.getSQL());
        for (int i = 0; i < this.params.size(); ++i) {
            Object object = this.params.get(i);
            this.setValue(preparedStatement, i + 1, object);
        }
        return preparedStatement;
    }
}

