/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf;

import java.util.HashMap;
import org.h2.bnf.BnfVisitor;
import org.h2.bnf.Rule;
import org.h2.bnf.RuleHead;
import org.h2.bnf.Sentence;

public class RuleFixed
implements Rule {
    public static final int YMD = 0;
    public static final int HMS = 1;
    public static final int NANOS = 2;
    public static final int ANY_EXCEPT_SINGLE_QUOTE = 3;
    public static final int ANY_EXCEPT_DOUBLE_QUOTE = 4;
    public static final int ANY_UNTIL_EOL = 5;
    public static final int ANY_UNTIL_END = 6;
    public static final int ANY_WORD = 7;
    public static final int ANY_EXCEPT_2_DOLLAR = 8;
    public static final int HEX_START = 10;
    public static final int CONCAT = 11;
    public static final int AZ_UNDERSCORE = 12;
    public static final int AF = 13;
    public static final int DIGIT = 14;
    public static final int OPEN_BRACKET = 15;
    public static final int CLOSE_BRACKET = 16;
    private final int type;

    RuleFixed(int n) {
        this.type = n;
    }

    public String toString() {
        switch (this.type) {
            case 0: {
                return "2000-01-01";
            }
            case 1: {
                return "12:00";
            }
            case 2: {
                return "0";
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return "XYZ";
            }
            case 10: {
                return "0x";
            }
            case 11: {
                return "||";
            }
            case 12: {
                return "A";
            }
            case 13: {
                return "F";
            }
            case 14: {
                return "0";
            }
            case 15: {
                return "[";
            }
            case 16: {
                return "]";
            }
        }
        throw new AssertionError((Object)("type=" + this.type));
    }

    @Override
    public void accept(BnfVisitor bnfVisitor) {
        bnfVisitor.visitRuleFixed(this.type);
    }

    @Override
    public String name() {
        return "type=" + this.type;
    }

    @Override
    public void setLinks(HashMap<String, RuleHead> hashMap) {
    }

    @Override
    public boolean matchRemove(Sentence sentence) {
        if (sentence.shouldStop()) {
            return false;
        }
        String string = sentence.getQuery();
        if (string.length() == 0) {
            return false;
        }
        String string2 = string;
        block0 : switch (this.type) {
            case 0: {
                while (string2.length() > 0 && "0123456789- ".indexOf(string2.charAt(0)) >= 0) {
                    string2 = string2.substring(1);
                }
                break;
            }
            case 1: {
                while (string2.length() > 0 && "0123456789:. ".indexOf(string2.charAt(0)) >= 0) {
                    string2 = string2.substring(1);
                }
                break;
            }
            case 2: {
                while (string2.length() > 0 && Character.isDigit(string2.charAt(0))) {
                    string2 = string2.substring(1);
                }
                break;
            }
            case 7: {
                while (string2.length() > 0 && Character.isWhitespace(string2.charAt(0))) {
                    string2 = string2.substring(1);
                }
                break;
            }
            case 6: {
                while (string2.length() > 1 && string2.startsWith("*/")) {
                    string2 = string2.substring(1);
                }
                break;
            }
            case 5: {
                while (string2.length() > 0 && string2.charAt(0) != '\n') {
                    string2 = string2.substring(1);
                }
                break;
            }
            case 3: {
                while (true) {
                    if (string2.length() > 0 && string2.charAt(0) != '\'') {
                        string2 = string2.substring(1);
                        continue;
                    }
                    if (!string2.startsWith("''")) break block0;
                    string2 = string2.substring(2);
                }
            }
            case 4: {
                while (true) {
                    if (string2.length() > 0 && string2.charAt(0) != '\"') {
                        string2 = string2.substring(1);
                        continue;
                    }
                    if (!string2.startsWith("\"\"")) break block0;
                    string2 = string2.substring(2);
                }
            }
            case 8: {
                while (string2.length() > 0 && !string2.startsWith("$$")) {
                    string2 = string2.substring(1);
                }
                break;
            }
            case 10: {
                if (string2.startsWith("0X") || string2.startsWith("0x")) {
                    string2 = string2.substring(2);
                    break;
                }
                if (!string2.startsWith("0")) break;
                string2 = string2.substring(1);
                break;
            }
            case 11: {
                if (string2.startsWith("||")) {
                    string2 = string2.substring(2);
                    break;
                }
                if (!string2.startsWith("|")) break;
                string2 = string2.substring(1);
                break;
            }
            case 12: {
                if (string2.length() <= 0 || !Character.isLetter(string2.charAt(0)) && string2.charAt(0) != '_') break;
                string2 = string2.substring(1);
                break;
            }
            case 13: {
                char c;
                if (string2.length() <= 0 || (c = Character.toUpperCase(string2.charAt(0))) < 'A' || c > 'F') break;
                string2 = string2.substring(1);
                break;
            }
            case 14: {
                if (string2.length() <= 0 || !Character.isDigit(string2.charAt(0))) break;
                string2 = string2.substring(1);
                break;
            }
            case 15: {
                string2 = string2.substring(1);
                break;
            }
            case 16: {
                string2 = string2.substring(1);
                break;
            }
            default: {
                throw new AssertionError((Object)("type=" + this.type));
            }
        }
        if (string2.equals(string)) {
            return false;
        }
        sentence.setQuery(string2);
        return true;
    }

    @Override
    public void addNextTokenList(Sentence sentence) {
        if (sentence.shouldStop()) {
            return;
        }
        String string = sentence.getQuery();
        switch (this.type) {
            case 0: {
                if (string.length() != 0) break;
                sentence.add("2006-01-01", "2006-01-01", 1);
                break;
            }
            case 1: {
                if (string.length() != 0) break;
                sentence.add("12:00:00", "12:00:00", 1);
                break;
            }
            case 2: {
                if (string.length() != 0) break;
                sentence.add("nanoseconds", "0", 1);
                break;
            }
            case 3: {
                if (string.length() != 0) break;
                sentence.add("anything", "Hello World", 1);
                sentence.add("'", "'", 1);
                break;
            }
            case 8: {
                if (string.length() != 0) break;
                sentence.add("anything", "Hello World", 1);
                sentence.add("'", "'", 1);
                break;
            }
            case 4: {
                if (string.length() != 0) break;
                sentence.add("anything", "identifier", 1);
                break;
            }
            case 7: {
                break;
            }
            case 10: {
                if (string.length() == 0) {
                    sentence.add("0x", "0x", 1);
                    break;
                }
                if (!"0".equals(string)) break;
                sentence.add("0x", "x", 1);
                break;
            }
            case 11: {
                if (string.length() == 0) {
                    sentence.add("||", "||", 1);
                    break;
                }
                if (!"|".equals(string)) break;
                sentence.add("||", "|", 1);
                break;
            }
            case 12: {
                if (string.length() != 0) break;
                sentence.add("character", "A", 1);
                break;
            }
            case 13: {
                if (string.length() != 0) break;
                sentence.add("hex character", "0A", 1);
                break;
            }
            case 14: {
                if (string.length() != 0) break;
                sentence.add("digit", "1", 1);
                break;
            }
            case 15: {
                sentence.add("[", "[", 1);
                break;
            }
            case 16: {
                sentence.add("]", "]", 1);
                break;
            }
            default: {
                throw new AssertionError((Object)("type=" + this.type));
            }
        }
    }
}

