/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.CharacterReference;
import au.id.jericho.lib.html.Config;
import au.id.jericho.lib.html.ParseText;
import au.id.jericho.lib.html.Source;

public class NumericCharacterReference
extends CharacterReference {
    private boolean hex;

    private NumericCharacterReference(Source source, int begin, int end, int codePoint, boolean hex) {
        super(source, begin, end, codePoint);
        this.hex = hex;
    }

    public boolean isDecimal() {
        return !this.hex;
    }

    public boolean isHexadecimal() {
        return this.hex;
    }

    public static String encode(CharSequence unencodedText) {
        if (unencodedText == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(unencodedText.length() * 2);
        for (int i = 0; i < unencodedText.length(); ++i) {
            char ch = unencodedText.charAt(i);
            if (CharacterReference.requiresEncoding(ch)) {
                CharacterReference.appendDecimalCharacterReferenceString(sb, ch);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String encodeDecimal(CharSequence unencodedText) {
        return NumericCharacterReference.encode(unencodedText);
    }

    public static String encodeHexadecimal(CharSequence unencodedText) {
        if (unencodedText == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(unencodedText.length() * 2);
        for (int i = 0; i < unencodedText.length(); ++i) {
            char ch = unencodedText.charAt(i);
            if (CharacterReference.requiresEncoding(ch)) {
                CharacterReference.appendHexadecimalCharacterReferenceString(sb, ch);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public String getCharacterReferenceString() {
        return this.hex ? CharacterReference.getHexadecimalCharacterReferenceString(this.codePoint) : CharacterReference.getDecimalCharacterReferenceString(this.codePoint);
    }

    public static String getCharacterReferenceString(int codePoint) {
        return CharacterReference.getDecimalCharacterReferenceString(codePoint);
    }

    /*
     * WARNING - void declaration
     */
    static CharacterReference construct(Source source, int begin, Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings) {
        void var9_11;
        int codePoint;
        boolean hex;
        block13: {
            void var8_12;
            int codePointStringBegin;
            ParseText parseText = source.getParseText();
            hex = parseText.charAt(codePointStringBegin = begin + 2) == 'x';
            if (hex) {
                ++codePointStringBegin;
            }
            int unterminatedMaxCodePoint = hex ? unterminatedCharacterReferenceSettings.hexadecimalCharacterReferenceMaxCodePoint : unterminatedCharacterReferenceSettings.decimalCharacterReferenceMaxCodePoint;
            int maxSourcePos = parseText.length() - 1;
            int x = codePointStringBegin;
            boolean unterminated = false;
            while (true) {
                String codePointString;
                int end;
                char ch;
                if ((ch = parseText.charAt(x)) == ';') {
                    end = x + 1;
                    codePointString = parseText.substring(codePointStringBegin, x);
                    break;
                }
                if (!(ch >= '0' && ch <= '9' || hex && ch >= 'a' && ch <= 'f')) {
                    unterminated = true;
                } else if (x == maxSourcePos) {
                    unterminated = true;
                    ++x;
                }
                if (unterminated) {
                    if (unterminatedMaxCodePoint == -1) {
                        return null;
                    }
                    end = x;
                    codePointString = parseText.substring(codePointStringBegin, x);
                    break;
                }
                ++x;
            }
            if (var8_12.length() == 0) {
                return null;
            }
            codePoint = -1;
            try {
                codePoint = Integer.parseInt((String)var8_12, hex ? 16 : 10);
                if (unterminated && codePoint > unterminatedMaxCodePoint) {
                    return null;
                }
                if (codePoint > 0x10FFFF) {
                    codePoint = -1;
                }
            }
            catch (NumberFormatException ex) {
                if (!unterminated) break block13;
                return null;
            }
        }
        return new NumericCharacterReference(source, begin, (int)var9_11, codePoint, hex);
    }

    public String getDebugInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append('\"');
        if (this.hex) {
            CharacterReference.appendHexadecimalCharacterReferenceString(sb, this.codePoint);
        } else {
            CharacterReference.appendDecimalCharacterReferenceString(sb, this.codePoint);
        }
        sb.append("\" ");
        CharacterReference.appendUnicodeText(sb, this.codePoint);
        sb.append(' ').append(super.getDebugInfo());
        return sb.toString();
    }
}

