/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.gigaspaces.store;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jini.core.entry.Entry;

public class FileEntry
implements Entry,
Externalizable {
    public String indexName;
    public String fileName;
    public Long lastModified;
    public Long size;

    public FileEntry() {
    }

    public FileEntry(String indexName, String fileName) {
        this.indexName = indexName;
        this.fileName = fileName;
    }

    public FileEntry(String indexName, String fileName, long size) {
        this.indexName = indexName;
        this.fileName = fileName;
        this.size = size;
        this.lastModified = System.currentTimeMillis();
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getSize() {
        return this.size;
    }

    public void touch() {
        this.lastModified = System.currentTimeMillis();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.indexName);
        if (this.fileName == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.fileName);
        }
        if (this.size == null && this.lastModified == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeLong(this.size);
            out.writeLong(this.lastModified);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.indexName = in.readUTF();
        if (in.readBoolean()) {
            this.fileName = in.readUTF();
        }
        if (in.readBoolean()) {
            this.size = in.readLong();
            this.lastModified = in.readLong();
        }
    }

    public static String[] __getSpaceIndexedFields() {
        return new String[]{"fileName"};
    }
}

