/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.indexing.indexer.Indexer;
import org.wso2.carbon.utils.CarbonUtils;

public class RegistryConfigLoader {
    private static Log log = LogFactory.getLog(RegistryConfigLoader.class);
    private long startingDelayInSecs;
    private long indexingFreqInSecs;
    private String lastAccessTimeLocation = null;
    private Map<String, Indexer> indexerMap = new HashMap<String, Indexer>();
    private List<Pattern> exclusionList = new ArrayList<Pattern>();
    private static RegistryConfigLoader instance = null;

    public RegistryConfigLoader() {
        try {
            FileInputStream fileInputStream = new FileInputStream(RegistryConfigLoader.getConfigFile());
            StAXOMBuilder builder = new StAXOMBuilder(CarbonUtils.replaceSystemVariablesInXml((InputStream)fileInputStream));
            OMElement configElement = builder.getDocumentElement();
            OMElement indexingConfig = configElement.getFirstChildWithName(new QName("indexingConfiguration"));
            try {
                this.startingDelayInSecs = Long.parseLong(indexingConfig.getFirstChildWithName(new QName("startingDelayInSeconds")).getText());
            }
            catch (Exception e) {
                this.startingDelayInSecs = 600L;
            }
            try {
                this.indexingFreqInSecs = Long.parseLong(indexingConfig.getFirstChildWithName(new QName("indexingFrequencyInSeconds")).getText());
            }
            catch (Exception e) {
                this.indexingFreqInSecs = 60L;
            }
            try {
                this.lastAccessTimeLocation = indexingConfig.getFirstChildWithName(new QName("lastAccessTimeLocation")).getText();
            }
            catch (OMException e) {
                this.lastAccessTimeLocation = "/_system/local/repository/components/org.wso2.carbon.registry/indexing/lastaccesstime";
            }
            Iterator exclusions = indexingConfig.getFirstChildWithName(new QName("exclusions")).getChildrenWithName(new QName("exclusion"));
            while (exclusions.hasNext()) {
                OMElement indexerEl = (OMElement)exclusions.next();
                String pathRegEx = indexerEl.getAttribute(new QName("pathRegEx")).getAttributeValue();
                if (pathRegEx == null) continue;
                try {
                    this.exclusionList.add(Pattern.compile(pathRegEx));
                }
                catch (PatternSyntaxException ignore) {}
            }
            Iterator indexers = indexingConfig.getFirstChildWithName(new QName("indexers")).getChildrenWithName(new QName("indexer"));
            while (indexers.hasNext()) {
                OMElement indexerEl = (OMElement)indexers.next();
                String clazz = indexerEl.getAttribute(new QName("class")).getAttributeValue();
                try {
                    Object indexerObj = this.getClass().getClassLoader().loadClass(clazz).newInstance();
                    if (!(indexerObj instanceof Indexer)) {
                        throw new RegistryException(clazz + " has not implemented Indexer interface");
                    }
                    String mediaPattern = indexerEl.getAttribute(new QName("mediaTypeRegEx")).getAttributeValue();
                    this.indexerMap.put(mediaPattern, (Indexer)indexerObj);
                }
                catch (InstantiationException e) {
                    log.error((Object)(clazz + " cannot be instantiated."), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)(clazz + " constructor cannot be accessed"), (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)(clazz + " is not found in classpath. Please check whether the class " + "is exported in your OSGI bundle."), (Throwable)e);
                }
                catch (RegistryException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (FileNotFoundException e) {
            log.error((Object)"registry.xml has not been found", (Throwable)e);
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (XMLStreamException e) {
            String msg = "error building registry.xml, check for badly formed xml";
            log.error((Object)msg, (Throwable)e);
        }
        catch (CarbonException e) {
            log.error((Object)"An error occurred during system variable replacement", (Throwable)e);
        }
    }

    public long getIndexingFreqInSecs() {
        return this.indexingFreqInSecs;
    }

    public String getLastAccessTimeLocation() {
        return this.lastAccessTimeLocation;
    }

    public Map<String, Indexer> getIndexerMap() {
        return this.indexerMap;
    }

    public Pattern[] getExclusionPatterns() {
        return this.exclusionList.toArray(new Pattern[this.exclusionList.size()]);
    }

    public long getStartingDelayInSecs() {
        return this.startingDelayInSecs;
    }

    private static File getConfigFile() throws RegistryException {
        String configPath = CarbonUtils.getRegistryXMLPath();
        if (configPath != null) {
            File registryXML = new File(configPath);
            if (!registryXML.exists()) {
                String msg = "Registry configuration file (registry.xml) file does not exist in the path " + configPath;
                log.error((Object)msg);
                throw new RegistryException(msg);
            }
            return registryXML;
        }
        String msg = "Cannot find registry.xml";
        log.error((Object)msg);
        throw new RegistryException(msg);
    }
}

