/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.feature.mgt.core.internal;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.equinox.internal.provisional.configurator.Configurator;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.feature.mgt.core.ProvisioningException;

public class ServiceHolder {
    private static String P2_AGENT_LOCATION = System.getProperty("carbon.home") + File.separator + "repository" + File.separator + "components" + File.separator + "p2";
    private static final Log log = LogFactory.getLog(ServiceHolder.class);
    private static IProvisioningAgentProvider provisioningAgentProvider;
    private static IArtifactRepositoryManager artifactRepositoryManager;
    private static IMetadataRepositoryManager metadataRepositoryManager;
    private static IProfileRegistry profileRegistry;
    private static IPlanner planner;
    private static IEngine p2Engine;
    private static ProvisioningContext provisioningContext;
    private static Configurator p2Configurator;
    private static ServerConfigurationService serverConfigurationService;
    public static final String ID = "org.wso2.carbon.feature.mgt.core";

    public static IMetadataRepositoryManager getMetadataRepositoryManager() throws ProvisioningException {
        if (metadataRepositoryManager == null) {
            throw new ProvisioningException("No MetadataRepositoryManager Service is found");
        }
        return metadataRepositoryManager;
    }

    public static IArtifactRepositoryManager getArtifactRepositoryManager() throws ProvisioningException {
        if (artifactRepositoryManager == null) {
            throw new ProvisioningException("No ArtifactRepositoryManager Service is found");
        }
        return artifactRepositoryManager;
    }

    public static IProfileRegistry getProfileRegistry() throws ProvisioningException {
        if (profileRegistry == null) {
            throw new ProvisioningException("No ProfileRegistry Service is found");
        }
        return profileRegistry;
    }

    public static IPlanner getPlanner() throws ProvisioningException {
        if (planner == null) {
            throw new ProvisioningException("No IPlanner Service is found");
        }
        return planner;
    }

    public static IEngine getP2Engine() throws ProvisioningException {
        if (p2Engine == null) {
            throw new ProvisioningException("No IEngine Service is found");
        }
        return p2Engine;
    }

    public static ProvisioningContext getProvisioningContext() throws ProvisioningException {
        if (provisioningContext == null) {
            throw new ProvisioningException("No ProvisioningContext found");
        }
        return provisioningContext;
    }

    public static ServerConfigurationService getServerConfigurationService() throws ProvisioningException {
        if (provisioningContext == null) {
            throw new ProvisioningException("No ServerConfiguration Service found");
        }
        return serverConfigurationService;
    }

    private static URI getAgentURI(String path) {
        URI uri = null;
        try {
            File file = new File(path);
            uri = file.getCanonicalFile().toURI();
        }
        catch (NullPointerException e) {
            log.error((Object)"Error while extracting p2 agent URI", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Error while extracting p2 agent URI", (Throwable)e);
        }
        return uri;
    }

    public static void setProvisioningAgentProvider(IProvisioningAgentProvider provisioningAgentProvider) {
        ServiceHolder.provisioningAgentProvider = provisioningAgentProvider;
        if (ServiceHolder.provisioningAgentProvider != null) {
            IProvisioningAgent provisioningAgent = null;
            try {
                URI agentURI = ServiceHolder.getAgentURI(P2_AGENT_LOCATION);
                provisioningAgent = provisioningAgentProvider.createAgent(agentURI);
            }
            catch (ProvisionException e) {
                log.error((Object)"provision Exception occurred", (Throwable)e);
            }
            if (provisioningAgent != null) {
                IPlanner planner = (IPlanner)provisioningAgent.getService(IPlanner.SERVICE_NAME);
                ServiceHolder.setPlanner(planner);
                IMetadataRepositoryManager metadataRepositoryManager = (IMetadataRepositoryManager)provisioningAgent.getService(IMetadataRepositoryManager.SERVICE_NAME);
                ServiceHolder.setMetadataRepositoryManager(metadataRepositoryManager);
                IArtifactRepositoryManager artifactRepositoryManager = (IArtifactRepositoryManager)provisioningAgent.getService(IArtifactRepositoryManager.SERVICE_NAME);
                ServiceHolder.setArtifactRepositoryManager(artifactRepositoryManager);
                IProfileRegistry profileRegistry = (IProfileRegistry)provisioningAgent.getService(IProfileRegistry.SERVICE_NAME);
                ServiceHolder.setProfileRegistry(profileRegistry);
                IEngine engine = (IEngine)provisioningAgent.getService(IEngine.SERVICE_NAME);
                ServiceHolder.setP2Engine(engine);
                ServiceHolder.setProvisioningContext(new ProvisioningContext(provisioningAgent));
                try {
                    provisioningAgent.registerService("org.eclipse.equinox.p2.installer.agent", (Object)provisioningAgentProvider.createAgent(null));
                }
                catch (ProvisionException e) {}
            } else {
                log.error((Object)"Error while getting provisioning agent");
            }
        } else {
            ServiceHolder.setPlanner(null);
            ServiceHolder.setMetadataRepositoryManager(null);
            ServiceHolder.setArtifactRepositoryManager(null);
            ServiceHolder.setProfileRegistry(null);
            ServiceHolder.setP2Engine(null);
        }
    }

    public static void setProvisioningContext(ProvisioningContext provisioningContext) {
        ServiceHolder.provisioningContext = provisioningContext;
    }

    public static void setArtifactRepositoryManager(IArtifactRepositoryManager artifactRepositoryManager) {
        ServiceHolder.artifactRepositoryManager = artifactRepositoryManager;
    }

    public static void setMetadataRepositoryManager(IMetadataRepositoryManager metadataRepositoryManager) {
        ServiceHolder.metadataRepositoryManager = metadataRepositoryManager;
    }

    public static void setProfileRegistry(IProfileRegistry profileRegistry) {
        ServiceHolder.profileRegistry = profileRegistry;
    }

    public static void setPlanner(IPlanner planner) {
        ServiceHolder.planner = planner;
    }

    public static void setP2Engine(IEngine p2Engine) {
        ServiceHolder.p2Engine = p2Engine;
    }

    public static void setServerConfigurationService(ServerConfigurationService serverConfigService) {
        serverConfigurationService = serverConfigService;
    }
}

