/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.server.ChildFirstURLClassLoader;
import org.wso2.carbon.server.util.Utils;

public class CarbonLauncher {
    private static Log log = LogFactory.getLog(CarbonLauncher.class);
    protected static final String FILE_SCHEME = "file:";
    protected static final String FRAMEWORK_BUNDLE_NAME = "org.eclipse.osgi";
    protected static final String STARTER = "org.eclipse.core.runtime.adaptor.EclipseStarter";
    protected static final String FRAMEWORKPROPERTIES = "org.eclipse.osgi.framework.internal.core.FrameworkProperties";
    protected static final String NULL_IDENTIFIER = "@null";
    protected static final String OSGI_FRAMEWORK = "osgi.framework";
    protected static final String OSGI_INSTANCE_AREA = "osgi.instance.area";
    protected static final String OSGI_CONFIGURATION_AREA = "osgi.configuration.area";
    protected static final String OSGI_INSTALL_AREA = "osgi.install.area";
    private File platformDirectory;
    private URLClassLoader frameworkClassLoader;

    public void launch() {
        this.platformDirectory = Utils.getCarbonComponentRepo();
        if (this.platformDirectory == null) {
            throw new IllegalStateException("Could not start the Framework - (not deployed)");
        }
        if (this.frameworkClassLoader != null) {
            return;
        }
        final Map<String, String> initialPropsMap = this.buildInitialPropertyMap();
        String[] args2 = Utils.getArgs();
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            System.setProperty("osgi.framework.useSystemProperties", "false");
            this.frameworkClassLoader = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

                @Override
                public URLClassLoader run() {
                    ChildFirstURLClassLoader cl = null;
                    try {
                        cl = new ChildFirstURLClassLoader(new URL[]{new URL((String)initialPropsMap.get(CarbonLauncher.OSGI_FRAMEWORK))}, null);
                    }
                    catch (MalformedURLException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    return cl;
                }
            });
            Class<?> clazz = this.frameworkClassLoader.loadClass(STARTER);
            Method setInitialProperties = clazz.getMethod("setInitialProperties", Map.class);
            setInitialProperties.invoke(null, initialPropsMap);
            Method runMethod = clazz.getMethod("startup", String[].class, Runnable.class);
            runMethod.invoke(null, new Object[]{args2, null});
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t == null) {
                t = ite;
            }
            throw new RuntimeException(t.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    private Map<String, String> buildInitialPropertyMap() {
        HashMap<String, String> initialPropertyMap = new HashMap<String, String>();
        String carbonHome = System.getProperty("carbon.home");
        Properties launchProperties = Utils.loadProperties(carbonHome + File.separator + "repository" + File.separator + "conf" + File.separator + "etc" + File.separator + "launch.ini");
        Iterator<Map.Entry<Object, Object>> i$ = launchProperties.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<Object, Object> o;
            Map.Entry<Object, Object> entry = o = i$.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.endsWith("*")) {
                if (!value.equals(NULL_IDENTIFIER)) continue;
                Utils.clearPrefixedSystemProperties(key.substring(0, key.length() - 1), initialPropertyMap);
                continue;
            }
            if (value.equals(NULL_IDENTIFIER)) {
                initialPropertyMap.put(key, null);
                continue;
            }
            initialPropertyMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        try {
            if (initialPropertyMap.get(OSGI_INSTALL_AREA) == null) {
                initialPropertyMap.put(OSGI_INSTALL_AREA, this.platformDirectory.toURL().toExternalForm());
            }
            if (initialPropertyMap.get(OSGI_CONFIGURATION_AREA) == null) {
                File configurationDirectory = new File(this.platformDirectory, "configuration");
                initialPropertyMap.put(OSGI_CONFIGURATION_AREA, configurationDirectory.toURL().toExternalForm());
            }
            if (initialPropertyMap.get(OSGI_INSTANCE_AREA) == null) {
                File workspaceDirectory = new File(this.platformDirectory, "workspace");
                initialPropertyMap.put(OSGI_INSTANCE_AREA, workspaceDirectory.toURL().toExternalForm());
            }
            if (initialPropertyMap.get(OSGI_FRAMEWORK) == null) {
                String installArea = (String)initialPropertyMap.get(OSGI_INSTALL_AREA);
                if (installArea.startsWith(FILE_SCHEME)) {
                    installArea = installArea.substring(FILE_SCHEME.length());
                }
                String path = new File(installArea, "plugins").toString();
                if ((path = Utils.searchFor(FRAMEWORK_BUNDLE_NAME, path)) == null) {
                    throw new RuntimeException("Could not find framework");
                }
                initialPropertyMap.put(OSGI_FRAMEWORK, new File(path).toURL().toExternalForm());
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error establishing location");
        }
        return initialPropertyMap;
    }
}

