/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.analysis.KeepWordFilter;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.util.plugin.ResourceLoaderAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeepWordFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    private CharArraySet words;
    private boolean ignoreCase;

    @Override
    public void inform(ResourceLoader loader) {
        String wordFiles = (String)this.args.get("words");
        this.ignoreCase = this.getBoolean("ignoreCase", false);
        if (wordFiles != null) {
            try {
                List<String> files = StrUtils.splitFileNames(wordFiles);
                if (this.words == null && files.size() > 0) {
                    this.words = new CharArraySet(files.size() * 10, this.ignoreCase);
                }
                for (String file : files) {
                    List<String> wlist = loader.getLines(file.trim());
                    this.words.addAll(StopFilter.makeStopSet(wlist.toArray(new String[0]), this.ignoreCase));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setWords(Set<String> words) {
        this.words = new CharArraySet(words, this.ignoreCase);
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    @Override
    public KeepWordFilter create(TokenStream input) {
        return new KeepWordFilter(input, this.words, this.ignoreCase);
    }

    public CharArraySet getWords() {
        return this.words;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }
}

