/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.tools;

import java.io.PrintStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.jaggeryjs.jaggery.tools.CommandLineExecutor;
import org.jaggeryjs.jaggery.tools.JaggeryShell;

public final class CommandLineClient {
    private static final String CONSTANT_HELP = "help";
    private static final String CONSTANT_SHELL = "shell";
    private static final String CONSTANT_VERSION = "version";
    private static final String CONSTANT_QUIT = "quit";
    private static PrintStream out = System.out;

    private CommandLineClient() {
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            out.println("\nEmpty command. Please execute -help for instructions\n");
            return;
        }
        GnuParser commandLineParser = new GnuParser();
        Options options = new Options();
        options.addOption(CONSTANT_HELP, false, "Display Jaggery help messages");
        options.addOption(CONSTANT_SHELL, false, "Enter into the Jaggery shell to execute Jaggery expressions");
        options.addOption(CONSTANT_VERSION, false, "Get Jaggery version");
        options.addOption(CONSTANT_QUIT, false, "Quit Jaggery command line client (for shell mode)");
        try {
            CommandLine line = commandLineParser.parse(options, args);
            if (line.hasOption(CONSTANT_HELP)) {
                out.println("\n");
                CommandLineClient.help();
                out.println("\n");
            } else if (line.hasOption(CONSTANT_VERSION)) {
                out.println("\n");
                out.println(JaggeryShell.version());
                out.println("\n");
            } else if (line.hasOption(CONSTANT_SHELL)) {
                JaggeryShell.enterContext(new String[0]);
            } else if (line.hasOption(CONSTANT_QUIT)) {
                out.println("\nThis command only supports in shell mode\n");
            } else if (args[0] != null && args[0].contains(".jag")) {
                CommandLineExecutor.parseJaggeryScript(args[0]);
            } else {
                out.println("\nInvalid command. Please execute -help for instructions\n");
            }
        }
        catch (ParseException exp) {
            out.println("Unexpected exception:" + exp.getMessage());
        }
    }

    public static void help() {
        out.println("");
        out.println("Command                 Description");
        out.println("=======                 ===========");
        out.println("<script.jag>            Execute Jaggery file");
        out.println("<filepath/script.jag>   Execute Jaggery file in the file path");
        out.println("-help                \tDisplay Jaggery help messages");
        out.println("-quit\t                Quit Jaggery command line client (for shell mode)");
        out.println("-shell\t                Enter into the Jaggery shell to execute Jaggery expressions");
        out.println("-version\t\tGet Jaggery version");
        out.println("");
    }

    static {
        Logger rootLogger = Logger.getRootLogger();
        if (!rootLogger.getAllAppenders().hasMoreElements()) {
            rootLogger.setLevel(Level.OFF);
            rootLogger.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%-5p [%t]: %m%n")));
        }
    }
}

