/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.search.internal;

import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.registry.common.ResourceData;
import org.wso2.carbon.registry.core.dataaccess.QueryProcessor;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.queries.QueryProcessorManager;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.indexing.service.ContentSearchService;
import org.wso2.carbon.registry.search.Utils;
import org.wso2.carbon.registry.search.beans.AdvancedSearchResultsBean;
import org.wso2.carbon.registry.search.beans.CustomSearchParameterBean;
import org.wso2.carbon.registry.search.services.MetadataSearchService;
import org.wso2.carbon.registry.search.services.XPathQueryProcessor;
import org.wso2.carbon.registry.search.services.utils.AdvancedSearchResultsBeanPopulator;

public class RegistryMgtUISearchServiceComponent {
    private static Log log = LogFactory.getLog(RegistryMgtUISearchServiceComponent.class);
    private ServiceRegistration serviceRegistration;

    protected void activate(ComponentContext context) {
        MetadataSearchServiceImpl metadataSearchService = new MetadataSearchServiceImpl();
        this.serviceRegistration = context.getBundleContext().registerService(MetadataSearchService.class.getName(), (Object)metadataSearchService, null);
        try {
            QueryProcessorManager queryProcessorManager = Utils.getRegistryService().getRegistry("wso2.system.user").getRegistryContext().getQueryProcessorManager();
            if (queryProcessorManager.getQueryProcessor("application/vnd.wso2.xpath.query") == null) {
                queryProcessorManager.setQueryProcessor("application/vnd.wso2.xpath.query", (QueryProcessor)new XPathQueryProcessor(metadataSearchService));
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Unable to registry query processors", (Throwable)e);
        }
        log.debug((Object)"******* Registry Search bundle is activated ******* ");
    }

    protected void deactivate(ComponentContext context) {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
        log.debug((Object)"******* Registry Search bundle is deactivated ******* ");
    }

    protected void setRegistryService(RegistryService registryService) {
        Utils.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        Utils.setRegistryService(null);
    }

    protected void setIndexingService(ContentSearchService contentSearchService) {
        Utils.setContentSearchService(contentSearchService);
    }

    protected void unsetIndexingService(ContentSearchService contentSearchService) {
        Utils.setContentSearchService(null);
    }

    private static class MetadataSearchServiceImpl
    implements MetadataSearchService {
        private MetadataSearchServiceImpl() {
        }

        public ResourceData[] search(UserRegistry registry, Map<String, String> parameters) throws RegistryException {
            LinkedList<String[]> params = new LinkedList<String[]>();
            for (Map.Entry<String, String> e : parameters.entrySet()) {
                params.add(new String[]{e.getKey(), e.getValue()});
            }
            CustomSearchParameterBean parameterBean = new CustomSearchParameterBean();
            parameterBean.setParameterValues((String[][])params.toArray((T[])new String[params.size()][]));
            AdvancedSearchResultsBean resultsBean = AdvancedSearchResultsBeanPopulator.populate(null, registry, parameterBean);
            String errorMessage = resultsBean.getErrorMessage();
            if (errorMessage != null) {
                throw new RegistryException(errorMessage);
            }
            return resultsBean.getResourceDataList();
        }

        public ResourceData[] search(int tenantId, Map<String, String> parameters) throws RegistryException {
            return this.search(Utils.getRegistryService().getRegistry("wso2.system.user", tenantId), parameters);
        }

        public ResourceData[] search(Map<String, String> parameters) throws RegistryException {
            return this.search(-1234, parameters);
        }
    }
}

