/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.store.fs.FileSystem;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;
import org.h2.util.SortedProperties;
import org.h2.util.StringUtils;
import org.h2.value.Transfer;

public class FileLock
implements Runnable {
    public static final int LOCK_NO = 0;
    public static final int LOCK_FILE = 1;
    public static final int LOCK_SOCKET = 2;
    public static final int LOCK_SERIALIZED = 3;
    private static final String MAGIC = "FileLock";
    private static final String FILE = "file";
    private static final String SOCKET = "socket";
    private static final String SERIALIZED = "serialized";
    private static final int RANDOM_BYTES = 16;
    private static final int SLEEP_GAP = 25;
    private static final int TIME_GRANULARITY = 2000;
    private volatile String fileName;
    private volatile ServerSocket serverSocket;
    private FileSystem fs;
    private int sleep;
    private Trace trace;
    private long lastWrite;
    private String method;
    private String ipAddress;
    private Properties properties;
    private boolean locked;
    private String uniqueId;
    private Thread watchdog;

    public FileLock(TraceSystem traceSystem, String string, int n) {
        this.trace = traceSystem.getTrace("fileLock");
        this.fileName = string;
        this.sleep = n;
    }

    public synchronized void lock(int n) {
        this.fs = FileSystem.getInstance(this.fileName);
        this.checkServer();
        if (this.locked) {
            DbException.throwInternalError("already locked");
        }
        switch (n) {
            case 1: {
                this.lockFile();
                break;
            }
            case 2: {
                this.lockSocket();
                break;
            }
            case 3: {
                this.lockSerialized();
            }
        }
        this.locked = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unlock() {
        if (!this.locked) {
            return;
        }
        try {
            if (this.fileName != null && this.load().equals(this.properties)) {
                this.fs.delete(this.fileName);
            }
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (Exception exception) {
            this.trace.debug("unlock", exception);
        }
        finally {
            this.fileName = null;
            this.serverSocket = null;
            this.locked = false;
        }
        try {
            if (this.watchdog != null) {
                this.watchdog.interrupt();
            }
        }
        catch (Exception exception) {
            this.trace.debug("unlock", exception);
        }
    }

    public void setProperty(String string, String string2) {
        if (string2 == null) {
            this.properties.remove(string);
        } else {
            this.properties.put(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties save() {
        try {
            OutputStream outputStream = this.fs.openFileOutputStream(this.fileName, false);
            try {
                this.properties.store(outputStream, MAGIC);
            }
            finally {
                outputStream.close();
            }
            this.lastWrite = this.fs.getLastModified(this.fileName);
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("save " + this.properties);
            }
            return this.properties;
        }
        catch (IOException iOException) {
            throw this.getExceptionFatal("Could not save properties " + this.fileName, iOException);
        }
    }

    private void checkServer() {
        Object object;
        Properties properties = this.load();
        String string = properties.getProperty("server");
        if (string == null) {
            return;
        }
        boolean bl = false;
        String string2 = properties.getProperty("id");
        try {
            object = NetUtils.createSocket(string, 9092, false);
            Transfer transfer = new Transfer(null);
            transfer.setSocket((Socket)object);
            transfer.init();
            transfer.writeInt(6);
            transfer.writeInt(6);
            transfer.writeString(null);
            transfer.writeString(null);
            transfer.writeString(string2);
            transfer.writeInt(14);
            transfer.flush();
            int n = transfer.readInt();
            if (n == 1) {
                bl = true;
            }
            transfer.close();
            ((Socket)object).close();
        }
        catch (IOException iOException) {
            return;
        }
        if (bl) {
            object = DbException.get(90020, "Server is running");
            throw ((DbException)object).addSQL(string + "/" + string2);
        }
    }

    public Properties load() {
        try {
            SortedProperties sortedProperties = SortedProperties.loadProperties(this.fileName);
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("load " + sortedProperties);
            }
            return sortedProperties;
        }
        catch (IOException iOException) {
            throw this.getExceptionFatal("Could not load properties " + this.fileName, iOException);
        }
    }

    private void waitUntilOld() {
        for (int i = 0; i < 160; ++i) {
            long l = this.fs.getLastModified(this.fileName);
            long l2 = System.currentTimeMillis() - l;
            if (l2 < -2000L) {
                try {
                    Thread.sleep(2 * this.sleep);
                }
                catch (Exception exception) {
                    this.trace.debug("sleep", exception);
                }
                return;
            }
            if (l2 > 2000L) {
                return;
            }
            try {
                Thread.sleep(25L);
                continue;
            }
            catch (Exception exception) {
                this.trace.debug("sleep", exception);
            }
        }
        throw this.getExceptionFatal("Lock file recently modified", null);
    }

    private void setUniqueId() {
        byte[] byArray = MathUtils.secureRandomBytes(16);
        String string = StringUtils.convertBytesToString(byArray);
        this.uniqueId = Long.toHexString(System.currentTimeMillis()) + string;
        this.properties.setProperty("id", this.uniqueId);
    }

    private void lockSerialized() {
        this.method = SERIALIZED;
        this.fs.createDirs(this.fileName);
        if (!this.fs.createNewFile(this.fileName)) {
            try {
                this.properties = this.load();
            }
            catch (DbException dbException) {
                // empty catch block
            }
            return;
        }
        this.properties = new SortedProperties();
        this.properties.setProperty("method", String.valueOf(this.method));
        this.setUniqueId();
        this.save();
    }

    private void lockFile() {
        this.method = FILE;
        this.properties = new SortedProperties();
        this.properties.setProperty("method", String.valueOf(this.method));
        this.setUniqueId();
        this.fs.createDirs(this.fileName);
        if (!this.fs.createNewFile(this.fileName)) {
            this.waitUntilOld();
            String string = this.load().getProperty("method", FILE);
            if (!string.equals(FILE)) {
                throw this.getExceptionFatal("Unsupported lock method " + string, null);
            }
            this.save();
            this.sleep(2 * this.sleep);
            if (!this.load().equals(this.properties)) {
                throw this.getExceptionAlreadyInUse("Locked by another process");
            }
            this.fs.delete(this.fileName);
            if (!this.fs.createNewFile(this.fileName)) {
                throw this.getExceptionFatal("Another process was faster", null);
            }
        }
        this.save();
        this.sleep(25);
        if (!this.load().equals(this.properties)) {
            this.fileName = null;
            throw this.getExceptionFatal("Concurrent update", null);
        }
        this.watchdog = new Thread(this);
        this.watchdog.setName("H2 File Lock Watchdog " + this.fileName);
        this.watchdog.setDaemon(true);
        this.watchdog.setPriority(9);
        this.watchdog.start();
    }

    private void lockSocket() {
        this.method = SOCKET;
        this.properties = new SortedProperties();
        this.properties.setProperty("method", String.valueOf(this.method));
        this.setUniqueId();
        this.ipAddress = NetUtils.getLocalAddress();
        this.fs.createDirs(this.fileName);
        if (!this.fs.createNewFile(this.fileName)) {
            InetAddress inetAddress;
            this.waitUntilOld();
            long l = this.fs.getLastModified(this.fileName);
            Properties properties = this.load();
            String string = properties.getProperty("method", SOCKET);
            if (string.equals(FILE)) {
                this.lockFile();
                return;
            }
            if (!string.equals(SOCKET)) {
                throw this.getExceptionFatal("Unsupported lock method " + string, null);
            }
            String string2 = properties.getProperty("ipAddress", this.ipAddress);
            if (!this.ipAddress.equals(string2)) {
                throw this.getExceptionAlreadyInUse("Locked by another computer: " + string2);
            }
            String string3 = properties.getProperty("port", "0");
            int n = Integer.parseInt(string3);
            try {
                inetAddress = InetAddress.getByName(string2);
            }
            catch (UnknownHostException unknownHostException) {
                throw this.getExceptionFatal("Unknown host " + string2, unknownHostException);
            }
            for (int i = 0; i < 3; ++i) {
                try {
                    Socket socket = new Socket(inetAddress, n);
                    socket.close();
                    throw this.getExceptionAlreadyInUse("Locked by another process");
                }
                catch (BindException bindException) {
                    throw this.getExceptionFatal("Bind Exception", null);
                }
                catch (ConnectException connectException) {
                    this.trace.debug("Socket not connected to port " + string3, connectException);
                    continue;
                }
                catch (IOException iOException) {
                    throw this.getExceptionFatal("IOException", null);
                }
            }
            if (l != this.fs.getLastModified(this.fileName)) {
                throw this.getExceptionFatal("Concurrent update", null);
            }
            this.fs.delete(this.fileName);
            if (!this.fs.createNewFile(this.fileName)) {
                throw this.getExceptionFatal("Another process was faster", null);
            }
        }
        try {
            this.serverSocket = NetUtils.createServerSocket(0, false);
            int n = this.serverSocket.getLocalPort();
            this.properties.setProperty("ipAddress", this.ipAddress);
            this.properties.setProperty("port", String.valueOf(n));
        }
        catch (Exception exception) {
            this.trace.debug("lock", exception);
            this.serverSocket = null;
            this.lockFile();
            return;
        }
        this.save();
        this.watchdog = new Thread(this);
        this.watchdog.setDaemon(true);
        this.watchdog.setName("H2 File Lock Watchdog (Socket) " + this.fileName);
        this.watchdog.start();
    }

    private void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            throw this.getExceptionFatal("Sleep interrupted", interruptedException);
        }
    }

    private DbException getExceptionFatal(String string, Throwable throwable) {
        return DbException.get(8000, throwable, string);
    }

    private DbException getExceptionAlreadyInUse(String string) {
        DbException dbException = DbException.get(90020, string);
        if (this.fileName != null) {
            try {
                Properties properties = this.load();
                String string2 = properties.getProperty("server") + "/" + properties.getProperty("id");
                dbException = dbException.addSQL(string2);
            }
            catch (DbException dbException2) {
                // empty catch block
            }
        }
        return dbException;
    }

    public static int getFileLockMethod(String string) {
        if (string == null || string.equalsIgnoreCase("FILE")) {
            return 1;
        }
        if (string.equalsIgnoreCase("NO")) {
            return 0;
        }
        if (string.equalsIgnoreCase("SOCKET")) {
            return 2;
        }
        if (string.equalsIgnoreCase("SERIALIZED")) {
            return 3;
        }
        throw DbException.get(90060, string);
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public void run() {
        try {
            while (this.fileName != null) {
                try {
                    if (!this.fs.exists(this.fileName) || this.fs.getLastModified(this.fileName) != this.lastWrite) {
                        this.save();
                    }
                    Thread.sleep(this.sleep);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                }
                catch (InterruptedException interruptedException) {
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (Exception exception) {
                    this.trace.debug("watchdog", exception);
                }
            }
            while (this.serverSocket != null) {
                try {
                    this.trace.debug("watchdog accept");
                    Socket socket = this.serverSocket.accept();
                    socket.close();
                }
                catch (Exception exception) {
                    this.trace.debug("watchdog", exception);
                }
            }
        }
        catch (Exception exception) {
            this.trace.debug("watchdog", exception);
        }
        this.trace.debug("watchdog end");
    }
}

