/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.io.ByteArrayOutputStream;
import org.apache.poi.hssf.record.CommonObjectDataSubRecord;
import org.apache.poi.hssf.record.EmbeddedObjectRefSubRecord;
import org.apache.poi.hssf.record.EndSubRecord;
import org.apache.poi.hssf.record.GroupMarkerSubRecord;
import org.apache.poi.hssf.record.NoteStructureSubRecord;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.formula.Area3DPtg;
import org.apache.poi.hssf.record.formula.AreaPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.Ref3DPtg;
import org.apache.poi.hssf.record.formula.RefPtg;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianByteArrayInputStream;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;
import org.apache.poi.util.LittleEndianOutputStream;

public abstract class SubRecord {
    protected SubRecord() {
    }

    public static SubRecord createSubRecord(LittleEndianInput in) {
        int sid = in.readUShort();
        int secondUShort = in.readUShort();
        switch (sid) {
            case 21: {
                return new CommonObjectDataSubRecord(in, secondUShort);
            }
            case 9: {
                return new EmbeddedObjectRefSubRecord(in, secondUShort);
            }
            case 6: {
                return new GroupMarkerSubRecord(in, secondUShort);
            }
            case 0: {
                return new EndSubRecord(in, secondUShort);
            }
            case 13: {
                return new NoteStructureSubRecord(in, secondUShort);
            }
            case 19: {
                return new LbsDataSubRecord(in, secondUShort);
            }
        }
        return new UnknownSubRecord(in, sid, secondUShort);
    }

    protected abstract int getDataSize();

    public byte[] serialize() {
        int size = this.getDataSize() + 4;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(size);
        this.serialize(new LittleEndianOutputStream(baos));
        if (baos.size() != size) {
            throw new RuntimeException("write size mismatch");
        }
        return baos.toByteArray();
    }

    public abstract void serialize(LittleEndianOutput var1);

    public abstract Object clone();

    private static final class LbsDataSubRecord
    extends SubRecord {
        public static final int sid = 19;
        private int _unknownShort1;
        private int _unknownInt4;
        private Ptg _linkPtg;
        private Byte _unknownByte6;
        private int _nEntryCount;
        private int _selectedEntryIndex;
        private int _style;
        private int _unknownShort10;
        private int _comboStyle;
        private int _lineCount;
        private int _unknownShort13;

        public LbsDataSubRecord(LittleEndianInput in, int unknownShort1) {
            this._unknownShort1 = unknownShort1;
            int linkSize = in.readUShort();
            if (linkSize > 0) {
                int formulaSize = in.readUShort();
                this._unknownInt4 = in.readInt();
                byte[] buf = new byte[formulaSize];
                in.readFully(buf);
                this._linkPtg = LbsDataSubRecord.readRefPtg(buf);
                switch (linkSize - formulaSize - 6) {
                    case 1: {
                        this._unknownByte6 = new Byte(in.readByte());
                        break;
                    }
                    case 0: {
                        this._unknownByte6 = null;
                        break;
                    }
                    default: {
                        throw new RecordFormatException("Unexpected leftover bytes");
                    }
                }
            } else {
                this._unknownInt4 = 0;
                this._linkPtg = null;
                this._unknownByte6 = null;
            }
            this._nEntryCount = in.readUShort();
            this._selectedEntryIndex = in.readUShort();
            this._style = in.readUShort();
            this._unknownShort10 = in.readUShort();
            this._comboStyle = in.readUShort();
            this._lineCount = in.readUShort();
            this._unknownShort13 = in.readUShort();
        }

        protected int getDataSize() {
            int result = 2;
            if (this._linkPtg != null) {
                result += 2;
                result += 4;
                result += this._linkPtg.getSize();
                if (this._unknownByte6 != null) {
                    ++result;
                }
            }
            return result += 14;
        }

        public void serialize(LittleEndianOutput out) {
            out.writeShort(19);
            out.writeShort(this._unknownShort1);
            if (this._linkPtg == null) {
                out.writeShort(0);
            } else {
                int formulaSize = this._linkPtg.getSize();
                int linkSize = formulaSize + 6;
                if (this._unknownByte6 != null) {
                    ++linkSize;
                }
                out.writeShort(linkSize);
                out.writeShort(formulaSize);
                out.writeInt(this._unknownInt4);
                this._linkPtg.write(out);
                if (this._unknownByte6 != null) {
                    out.writeByte(this._unknownByte6.intValue());
                }
            }
            out.writeShort(this._nEntryCount);
            out.writeShort(this._selectedEntryIndex);
            out.writeShort(this._style);
            out.writeShort(this._unknownShort10);
            out.writeShort(this._comboStyle);
            out.writeShort(this._lineCount);
            out.writeShort(this._unknownShort13);
        }

        private static Ptg readRefPtg(byte[] formulaRawBytes) {
            LittleEndianByteArrayInputStream in = new LittleEndianByteArrayInputStream(formulaRawBytes);
            byte ptgSid = in.readByte();
            switch (ptgSid) {
                case 37: {
                    return new AreaPtg(in);
                }
                case 59: {
                    return new Area3DPtg(in);
                }
                case 36: {
                    return new RefPtg(in);
                }
                case 58: {
                    return new Ref3DPtg(in);
                }
            }
            return null;
        }

        public Object clone() {
            return this;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(256);
            sb.append("[ftLbsData]\n");
            sb.append("    .unknownShort1 =").append(HexDump.shortToHex(this._unknownShort1)).append("\n");
            if (this._linkPtg == null) {
                sb.append("  <no link formula>\n");
            } else {
                sb.append("    .unknownInt4   =").append(HexDump.intToHex(this._unknownInt4)).append("\n");
                sb.append("    .linkPtg       =").append(this._linkPtg.toFormulaString()).append(" (").append(this._linkPtg.getRVAType()).append(")").append("\n");
                if (this._unknownByte6 != null) {
                    sb.append("    .unknownByte6  =").append(HexDump.byteToHex(this._unknownByte6.byteValue())).append("\n");
                }
            }
            sb.append("    .nEntryCount   =").append(HexDump.shortToHex(this._nEntryCount)).append("\n");
            sb.append("    .selEntryIx    =").append(HexDump.shortToHex(this._selectedEntryIndex)).append("\n");
            sb.append("    .style         =").append(HexDump.shortToHex(this._style)).append("\n");
            sb.append("    .unknownShort10=").append(HexDump.shortToHex(this._unknownShort10)).append("\n");
            sb.append("    .comboStyle    =").append(HexDump.shortToHex(this._comboStyle)).append("\n");
            sb.append("    .lineCount     =").append(HexDump.shortToHex(this._lineCount)).append("\n");
            sb.append("    .unknownShort13=").append(HexDump.shortToHex(this._unknownShort13)).append("\n");
            sb.append("[/ftLbsData]\n");
            return sb.toString();
        }
    }

    private static final class UnknownSubRecord
    extends SubRecord {
        private final int _sid;
        private final byte[] _data;

        public UnknownSubRecord(LittleEndianInput in, int sid, int size) {
            this._sid = sid;
            byte[] buf = new byte[size];
            in.readFully(buf);
            this._data = buf;
        }

        protected int getDataSize() {
            return this._data.length;
        }

        public void serialize(LittleEndianOutput out) {
            out.writeShort(this._sid);
            out.writeShort(this._data.length);
            out.write(this._data);
        }

        public Object clone() {
            return this;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(64);
            sb.append(this.getClass().getName()).append(" [");
            sb.append("sid=").append(HexDump.shortToHex(this._sid));
            sb.append(" size=").append(this._data.length);
            sb.append(" : ").append(HexDump.toHex(this._data));
            sb.append("]\n");
            return sb.toString();
        }
    }
}

