/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.transform;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSDocInfoStore;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.transform.STRTransformUtil;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class STRTransform
extends TransformSpi {
    public static final String implementedTransformURI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform";
    private static Log log = LogFactory.getLog((String)STRTransform.class.getName());
    private static boolean doDebug = false;
    private static String XMLNS = "xmlns=";
    private WSDocInfo wsDocInfo = null;

    public boolean wantsOctetStream() {
        return false;
    }

    public boolean wantsNodeSet() {
        return true;
    }

    public boolean returnsOctetStream() {
        return true;
    }

    public boolean returnsNodeSet() {
        return false;
    }

    @Override
    protected String engineGetURI() {
        return implementedTransformURI;
    }

    @Override
    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input, OutputStream os, Transform _transformObject) throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException, ParserConfigurationException, SAXException {
        return this.enginePerformTransform(input, _transformObject);
    }

    @Override
    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input, Transform transformObject) throws IOException, CanonicalizationException, InvalidCanonicalizerException {
        doDebug = log.isDebugEnabled();
        if (doDebug) {
            log.debug((Object)("Beginning STRTransform..." + input.toString()));
        }
        try {
            Document thisDoc = transformObject.getDocument();
            this.wsDocInfo = WSDocInfoStore.lookup(thisDoc);
            if (this.wsDocInfo == null) {
                throw new CanonicalizationException("no WSDocInfo found");
            }
            String canonAlgo = null;
            if (transformObject.length("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "TransformationParameters") == 1) {
                Element tmpE = XMLUtils.selectNode(transformObject.getElement().getFirstChild(), "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "TransformationParameters", 0);
                Element canonElem = (Element)WSSecurityUtil.getDirectChild(tmpE, "CanonicalizationMethod", "http://www.w3.org/2000/09/xmldsig#");
                canonAlgo = canonElem.getAttribute("Algorithm");
                if (doDebug) {
                    log.debug((Object)("CanonAlgo: " + canonAlgo));
                }
            }
            Canonicalizer canon = Canonicalizer.getInstance(canonAlgo);
            ByteArrayOutputStream bos = null;
            byte[] buf = null;
            if (doDebug) {
                buf = input.getBytes();
                bos = new ByteArrayOutputStream(buf.length);
                bos.write(buf, 0, buf.length);
                log.debug((Object)("canon bos: " + bos.toString()));
            }
            Element str = null;
            if (!input.isElement()) {
                throw new CanonicalizationException("Wrong input format - only element input supported");
            }
            str = (Element)input.getSubNode();
            if (doDebug) {
                log.debug((Object)("STR: " + str.toString()));
            }
            SecurityTokenReference secRef = new SecurityTokenReference(str);
            Element dereferencedToken = STRTransformUtil.dereferenceSTR(thisDoc, secRef, this.wsDocInfo);
            buf = canon.canonicalizeSubtree(dereferencedToken, "#default");
            if (doDebug) {
                bos = new ByteArrayOutputStream(buf.length);
                bos.write(buf, 0, buf.length);
                log.debug((Object)("after c14n: " + bos.toString()));
            }
            StringBuffer bf = new StringBuffer(new String(buf));
            String bf1 = bf.toString();
            int gt = bf1.indexOf(">");
            int idx = bf1.indexOf(XMLNS);
            if (idx < 0 || idx > gt) {
                idx = bf1.indexOf(" ");
                bf.insert(idx + 1, "xmlns=\"\" ");
                bf1 = bf.toString();
            }
            if (doDebug) {
                log.debug((Object)"last result: ");
                log.debug((Object)bf1);
            }
            return new XMLSignatureInput(bf1.getBytes());
        }
        catch (WSSecurityException ex) {
            log.debug((Object)ex.getMessage(), (Throwable)ex);
            throw new CanonicalizationException("c14n.Canonicalizer.Exception", ex);
        }
    }
}

