/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.saml;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.saml.SAMLIssuer;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.keyvalues.DSAKeyValue;
import org.apache.xml.security.keys.content.keyvalues.RSAKeyValue;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAuthenticationStatement;
import org.opensaml.SAMLException;
import org.opensaml.SAMLNameIdentifier;
import org.opensaml.SAMLStatement;
import org.opensaml.SAMLSubject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SAMLIssuerImpl
implements SAMLIssuer {
    private static final Log log = LogFactory.getLog((String)SAMLIssuerImpl.class.getName());
    private SAMLAssertion sa = null;
    private Document instanceDoc = null;
    private Properties properties = null;
    private Crypto issuerCrypto = null;
    private String issuerKeyPassword = null;
    private String issuerKeyName = null;
    private boolean senderVouches = true;
    private String[] confirmationMethods = new String[1];
    private Crypto userCrypto = null;
    private String username = null;
    private boolean sendKeyValue = false;

    public SAMLIssuerImpl() {
    }

    public SAMLIssuerImpl(Properties prop) {
        String sendKeyValueProp;
        if (prop == null) {
            return;
        }
        this.properties = prop;
        String cryptoProp = this.properties.getProperty("org.apache.ws.security.saml.issuer.cryptoProp.file");
        if (cryptoProp != null) {
            this.issuerCrypto = CryptoFactory.getInstance(cryptoProp);
            this.issuerKeyName = this.properties.getProperty("org.apache.ws.security.saml.issuer.key.name");
            this.issuerKeyPassword = this.properties.getProperty("org.apache.ws.security.saml.issuer.key.password");
        }
        if ((sendKeyValueProp = this.properties.getProperty("org.apache.ws.security.saml.issuer.sendKeyValue")) != null) {
            this.sendKeyValue = Boolean.valueOf(sendKeyValueProp);
        }
        if ("senderVouches".equals(this.properties.getProperty("org.apache.ws.security.saml.confirmationMethod"))) {
            this.confirmationMethods[0] = "urn:oasis:names:tc:SAML:1.0:cm:sender-vouches";
        } else if ("keyHolder".equals(this.properties.getProperty("org.apache.ws.security.saml.confirmationMethod"))) {
            this.confirmationMethods[0] = "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key";
            this.senderVouches = false;
        }
    }

    @Override
    public SAMLAssertion newAssertion() {
        block20: {
            log.debug((Object)"Begin add SAMLAssertion token...");
            String issuer = this.properties.getProperty("org.apache.ws.security.saml.issuer");
            String name = this.properties.getProperty("org.apache.ws.security.saml.subjectNameId.name");
            String qualifier = this.properties.getProperty("org.apache.ws.security.saml.subjectNameId.qualifier");
            try {
                SAMLNameIdentifier nameId = new SAMLNameIdentifier(name, qualifier, "");
                String subjectIP = null;
                String authMethod = null;
                if ("password".equals(this.properties.getProperty("org.apache.ws.security.saml.authenticationMethod"))) {
                    authMethod = "urn:oasis:names:tc:SAML:1.0:am:password";
                }
                Date authInstant = new Date();
                Collection bindings = null;
                SAMLSubject subject = new SAMLSubject(nameId, Arrays.asList(this.confirmationMethods), null, null);
                SAMLStatement[] statements = new SAMLStatement[]{new SAMLAuthenticationStatement(subject, authMethod, authInstant, subjectIP, null, bindings)};
                this.sa = new SAMLAssertion(issuer, null, null, null, null, Arrays.asList(statements));
                if (this.senderVouches) break block20;
                KeyInfo ki = new KeyInfo(this.instanceDoc);
                try {
                    X509Certificate[] certs = this.userCrypto.getCertificates(this.username);
                    if (this.sendKeyValue) {
                        PublicKey key = certs[0].getPublicKey();
                        String pubKeyAlgo = key.getAlgorithm();
                        if ("DSA".equalsIgnoreCase(pubKeyAlgo)) {
                            DSAKeyValue dsaKeyValue = new DSAKeyValue(this.instanceDoc, key);
                            ki.add(dsaKeyValue);
                        } else if ("RSA".equalsIgnoreCase(pubKeyAlgo)) {
                            RSAKeyValue rsaKeyValue = new RSAKeyValue(this.instanceDoc, key);
                            ki.add(rsaKeyValue);
                        }
                    } else {
                        X509Data certElem = new X509Data(this.instanceDoc);
                        certElem.addCertificate(certs[0]);
                        ki.add(certElem);
                    }
                }
                catch (WSSecurityException ex) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)ex.getMessage(), (Throwable)ex);
                    }
                    return null;
                }
                catch (XMLSecurityException ex) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)ex.getMessage(), (Throwable)ex);
                    }
                    return null;
                }
                Element keyInfoElement = ki.getElement();
                keyInfoElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
                subject.setKeyInfo((Object)ki);
                try {
                    X509Certificate[] issuerCerts = this.issuerCrypto.getCertificates(this.issuerKeyName);
                    String sigAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
                    String pubKeyAlgo = issuerCerts[0].getPublicKey().getAlgorithm();
                    log.debug((Object)("automatic sig algo detection: " + pubKeyAlgo));
                    if (pubKeyAlgo.equalsIgnoreCase("DSA")) {
                        sigAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
                    }
                    PrivateKey issuerPK = this.issuerCrypto.getPrivateKey(this.issuerKeyName, this.issuerKeyPassword);
                    this.sa.sign(sigAlgo, (Key)issuerPK, Arrays.asList(issuerCerts));
                }
                catch (WSSecurityException ex) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)ex.getMessage(), (Throwable)ex);
                    }
                    return null;
                }
                catch (Exception ex) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)ex.getMessage(), (Throwable)ex);
                    }
                    return null;
                }
            }
            catch (SAMLException ex) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)ex.getMessage(), (Throwable)ex);
                }
                throw new RuntimeException(ex.toString(), ex);
            }
        }
        return this.sa;
    }

    @Override
    public void setUserCrypto(Crypto userCrypto) {
        this.userCrypto = userCrypto;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public Crypto getIssuerCrypto() {
        return this.issuerCrypto;
    }

    @Override
    public String getIssuerKeyName() {
        return this.issuerKeyName;
    }

    @Override
    public String getIssuerKeyPassword() {
        return this.issuerKeyPassword;
    }

    @Override
    public boolean isSenderVouches() {
        return this.senderVouches;
    }

    @Override
    public void setInstanceDoc(Document instanceDoc) {
        this.instanceDoc = instanceDoc;
    }
}

