/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.search.ConstantScoreRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.PriorityQueue;
import org.apache.solr.analysis.TokenFilterFactory;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.analysis.TokenizerFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.luke.FieldFlag;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Base64;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LukeRequestHandler
extends RequestHandlerBase {
    private static Logger log = LoggerFactory.getLogger(LukeRequestHandler.class);
    public static final String NUMTERMS = "numTerms";
    public static final String DOC_ID = "docId";
    public static final String ID = "id";
    public static final int DEFAULT_COUNT = 10;

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        IndexSchema schema = req.getSchema();
        SolrIndexSearcher searcher = req.getSearcher();
        SolrIndexReader reader = searcher.getReader();
        SolrParams params = req.getParams();
        int numTerms = params.getInt(NUMTERMS, 10);
        rsp.add("index", LukeRequestHandler.getIndexInfo(reader, numTerms > 0));
        Integer docId = params.getInt(DOC_ID);
        if (docId == null && params.get(ID) != null) {
            SchemaField uniqueKey = schema.getUniqueKeyField();
            String v = uniqueKey.getType().toInternal(params.get(ID));
            Term t = new Term(uniqueKey.getName(), v);
            docId = searcher.getFirstMatch(t);
            if (docId < 0) {
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "Can't find document: " + params.get(ID));
            }
        }
        if (docId != null) {
            Document doc = null;
            try {
                doc = ((IndexReader)reader).document(docId);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (doc == null) {
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "Can't find document: " + docId);
            }
            SimpleOrderedMap<Object> info = LukeRequestHandler.getDocumentFieldsInfo(doc, docId, reader, schema);
            SimpleOrderedMap<Serializable> docinfo = new SimpleOrderedMap<Serializable>();
            docinfo.add(DOC_ID, docId);
            docinfo.add("lucene", info);
            docinfo.add("solr", doc);
            rsp.add("doc", docinfo);
        } else if ("schema".equals(params.get("show"))) {
            rsp.add("schema", LukeRequestHandler.getSchemaInfo(req.getSchema()));
        } else {
            HashSet<String> fields = null;
            if (params.get("fl") != null) {
                fields = new HashSet<String>();
                for (String f : params.getParams("fl")) {
                    fields.add(f);
                }
            }
            rsp.add("fields", LukeRequestHandler.getIndexedFieldsInfo(searcher, fields, numTerms));
        }
        SimpleOrderedMap<Object> info = new SimpleOrderedMap<Object>();
        info.add("key", LukeRequestHandler.getFieldFlagsKey());
        info.add("NOTE", "Document Frequency (df) is not updated when a document is marked for deletion.  df values include deleted documents.");
        rsp.add("info", info);
        rsp.setHttpCaching(false);
    }

    private static String getFieldFlags(Fieldable f) {
        StringBuilder flags = new StringBuilder();
        flags.append(f != null && f.isIndexed() ? FieldFlag.INDEXED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.isTokenized() ? FieldFlag.TOKENIZED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.isStored() ? FieldFlag.STORED.getAbbreviation() : (char)'-');
        flags.append('-');
        flags.append(f != null && f.isTermVectorStored() ? FieldFlag.TERM_VECTOR_STORED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.isStoreOffsetWithTermVector() ? FieldFlag.TERM_VECTOR_OFFSET.getAbbreviation() : (char)'-');
        flags.append(f != null && f.isStorePositionWithTermVector() ? FieldFlag.TERM_VECTOR_POSITION.getAbbreviation() : (char)'-');
        flags.append(f != null && f.getOmitNorms() ? FieldFlag.OMIT_NORMS.getAbbreviation() : (char)'-');
        flags.append(f != null && f.isLazy() ? FieldFlag.LAZY.getAbbreviation() : (char)'-');
        flags.append(f != null && f.isBinary() ? FieldFlag.BINARY.getAbbreviation() : (char)'-');
        flags.append(f != null && f.isCompressed() ? FieldFlag.COMPRESSED.getAbbreviation() : (char)'-');
        flags.append('-');
        flags.append('-');
        return flags.toString();
    }

    private static String getFieldFlags(SchemaField f) {
        FieldType t = f == null ? null : f.getType();
        boolean lazy = false;
        boolean binary = false;
        StringBuilder flags = new StringBuilder();
        flags.append(f != null && f.indexed() ? FieldFlag.INDEXED.getAbbreviation() : (char)'-');
        flags.append(t != null && t.isTokenized() ? FieldFlag.TOKENIZED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.stored() ? FieldFlag.STORED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.multiValued() ? FieldFlag.MULTI_VALUED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.storeTermVector() ? FieldFlag.TERM_VECTOR_STORED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.storeTermOffsets() ? FieldFlag.TERM_VECTOR_OFFSET.getAbbreviation() : (char)'-');
        flags.append(f != null && f.storeTermPositions() ? FieldFlag.TERM_VECTOR_POSITION.getAbbreviation() : (char)'-');
        flags.append(f != null && f.omitNorms() ? FieldFlag.OMIT_NORMS.getAbbreviation() : (char)'-');
        flags.append(f != null && f.omitTf() ? FieldFlag.OMIT_TF.getAbbreviation() : (char)'-');
        flags.append(lazy ? (char)FieldFlag.LAZY.getAbbreviation() : (char)'-');
        flags.append(binary ? (char)FieldFlag.BINARY.getAbbreviation() : (char)'-');
        flags.append(f != null && f.isCompressed() ? FieldFlag.COMPRESSED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.sortMissingFirst() ? FieldFlag.SORT_MISSING_FIRST.getAbbreviation() : (char)'-');
        flags.append(f != null && f.sortMissingLast() ? FieldFlag.SORT_MISSING_LAST.getAbbreviation() : (char)'-');
        return flags.toString();
    }

    public static SimpleOrderedMap<String> getFieldFlagsKey() {
        SimpleOrderedMap<String> key = new SimpleOrderedMap<String>();
        key.add(String.valueOf(FieldFlag.INDEXED.getAbbreviation()), FieldFlag.INDEXED.getDisplay());
        key.add(String.valueOf(FieldFlag.TOKENIZED.getAbbreviation()), FieldFlag.TOKENIZED.getDisplay());
        key.add(String.valueOf(FieldFlag.STORED.getAbbreviation()), FieldFlag.STORED.getDisplay());
        key.add(String.valueOf(FieldFlag.MULTI_VALUED.getAbbreviation()), FieldFlag.MULTI_VALUED.getDisplay());
        key.add(String.valueOf(FieldFlag.TERM_VECTOR_STORED.getAbbreviation()), FieldFlag.TERM_VECTOR_STORED.getDisplay());
        key.add(String.valueOf(FieldFlag.TERM_VECTOR_OFFSET.getAbbreviation()), FieldFlag.TERM_VECTOR_OFFSET.getDisplay());
        key.add(String.valueOf(FieldFlag.TERM_VECTOR_POSITION.getAbbreviation()), FieldFlag.TERM_VECTOR_POSITION.getDisplay());
        key.add(String.valueOf(FieldFlag.OMIT_NORMS.getAbbreviation()), FieldFlag.OMIT_NORMS.getDisplay());
        key.add(String.valueOf(FieldFlag.LAZY.getAbbreviation()), FieldFlag.LAZY.getDisplay());
        key.add(String.valueOf(FieldFlag.BINARY.getAbbreviation()), FieldFlag.BINARY.getDisplay());
        key.add(String.valueOf(FieldFlag.COMPRESSED.getAbbreviation()), FieldFlag.COMPRESSED.getDisplay());
        key.add(String.valueOf(FieldFlag.SORT_MISSING_FIRST.getAbbreviation()), FieldFlag.SORT_MISSING_FIRST.getDisplay());
        key.add(String.valueOf(FieldFlag.SORT_MISSING_LAST.getAbbreviation()), FieldFlag.SORT_MISSING_LAST.getDisplay());
        return key;
    }

    private static SimpleOrderedMap<Object> getDocumentFieldsInfo(Document doc, int docId, IndexReader reader, IndexSchema schema) throws IOException {
        SimpleOrderedMap<Object> finfo = new SimpleOrderedMap<Object>();
        for (Object o : doc.getFields()) {
            Fieldable fieldable = (Fieldable)o;
            SimpleOrderedMap<Object> f = new SimpleOrderedMap<Object>();
            SchemaField sfield = schema.getFieldOrNull(fieldable.name());
            FieldType ftype = sfield == null ? null : sfield.getType();
            f.add("type", ftype == null ? null : ftype.getTypeName());
            f.add("schema", LukeRequestHandler.getFieldFlags(sfield));
            f.add("flags", LukeRequestHandler.getFieldFlags(fieldable));
            Term t = new Term(fieldable.name(), ftype != null ? ftype.storedToIndexed(fieldable) : fieldable.stringValue());
            f.add("value", ftype == null ? null : ftype.toExternal(fieldable));
            f.add("internal", fieldable.stringValue());
            byte[] arr = fieldable.getBinaryValue();
            if (arr != null) {
                f.add("binary", Base64.byteArrayToBase64(arr, 0, arr.length));
            }
            f.add("boost", Float.valueOf(fieldable.getBoost()));
            f.add("docFreq", t.text() == null ? 0 : reader.docFreq(t));
            if (fieldable.isTermVectorStored()) {
                try {
                    TermFreqVector v = reader.getTermFreqVector(docId, fieldable.name());
                    if (v != null) {
                        SimpleOrderedMap<Integer> tfv = new SimpleOrderedMap<Integer>();
                        for (int i = 0; i < v.size(); ++i) {
                            tfv.add(v.getTerms()[i], v.getTermFrequencies()[i]);
                        }
                        f.add("termVector", tfv);
                    }
                }
                catch (Exception ex) {
                    log.warn("error writing term vector", (Throwable)ex);
                }
            }
            finfo.add(fieldable.name(), f);
        }
        return finfo;
    }

    private static SimpleOrderedMap<Object> getIndexedFieldsInfo(SolrIndexSearcher searcher, Set<String> fields, int numTerms) throws Exception {
        SolrIndexReader reader = searcher.getReader();
        IndexSchema schema = searcher.getSchema();
        Map<String, TopTermQueue> ttinfo = null;
        if (numTerms > 0) {
            ttinfo = LukeRequestHandler.getTopTerms(reader, fields, numTerms, null);
        }
        SimpleOrderedMap<Object> finfo = new SimpleOrderedMap<Object>();
        Collection fieldNames = ((IndexReader)reader).getFieldNames(IndexReader.FieldOption.ALL);
        for (String fieldName : fieldNames) {
            if (fields != null && !fields.contains(fieldName)) continue;
            SimpleOrderedMap<Object> f = new SimpleOrderedMap<Object>();
            SchemaField sfield = schema.getFieldOrNull(fieldName);
            FieldType ftype = sfield == null ? null : sfield.getType();
            f.add("type", ftype == null ? null : ftype.getTypeName());
            f.add("schema", LukeRequestHandler.getFieldFlags(sfield));
            if (sfield != null && schema.isDynamicField(sfield.getName()) && schema.getDynamicPattern(sfield.getName()) != null) {
                f.add("dynamicBase", schema.getDynamicPattern(sfield.getName()));
            }
            if (ttinfo != null && sfield != null && sfield.indexed()) {
                ConstantScoreRangeQuery q = new ConstantScoreRangeQuery(fieldName, null, null, false, false);
                TopDocs top = searcher.search((Query)q, 1);
                if (top.totalHits > 0) {
                    try {
                        Document doc = searcher.doc(top.scoreDocs[0].doc);
                        Fieldable fld = doc.getFieldable(fieldName);
                        if (fld != null) {
                            f.add("index", LukeRequestHandler.getFieldFlags(fld));
                        } else {
                            f.add("index", "(unstored field)");
                        }
                    }
                    catch (Exception ex) {
                        log.warn("error reading field: " + fieldName);
                    }
                }
                f.add("docs", top.totalHits);
                TopTermQueue topTerms = ttinfo.get(fieldName);
                if (topTerms != null) {
                    f.add("distinct", topTerms.distinctTerms);
                    f.add("topTerms", topTerms.toNamedList(searcher.getSchema()));
                    f.add("histogram", topTerms.histogram.toNamedList());
                }
            }
            finfo.add(fieldName, f);
        }
        return finfo;
    }

    private static SimpleOrderedMap<Object> getSchemaInfo(IndexSchema schema) {
        HashMap<String, List<String>> typeusemap = new HashMap<String, List<String>>();
        SimpleOrderedMap<Object> fields = new SimpleOrderedMap<Object>();
        SchemaField uniqueField = schema.getUniqueKeyField();
        for (SchemaField f : schema.getFields().values()) {
            LukeRequestHandler.populateFieldInfo(schema, typeusemap, fields, uniqueField, f);
        }
        SimpleOrderedMap<Object> dynamicFields = new SimpleOrderedMap<Object>();
        for (SchemaField f : schema.getDynamicFieldPrototypes()) {
            LukeRequestHandler.populateFieldInfo(schema, typeusemap, dynamicFields, uniqueField, f);
        }
        SimpleOrderedMap types = new SimpleOrderedMap();
        for (FieldType ft : schema.getFieldTypes().values()) {
            SimpleOrderedMap<Object> field = new SimpleOrderedMap<Object>();
            field.add("fields", typeusemap.get(ft.getTypeName()));
            field.add("tokenized", ft.isTokenized());
            field.add("className", ft.getClass().getName());
            field.add("indexAnalyzer", LukeRequestHandler.getAnalyzerInfo(ft.getAnalyzer()));
            field.add("queryAnalyzer", LukeRequestHandler.getAnalyzerInfo(ft.getQueryAnalyzer()));
            types.add(ft.getTypeName(), field);
        }
        SimpleOrderedMap<Object> finfo = new SimpleOrderedMap<Object>();
        finfo.add("fields", fields);
        finfo.add("dynamicFields", dynamicFields);
        finfo.add("uniqueKeyField", null == uniqueField ? null : uniqueField.getName());
        finfo.add("defaultSearchField", schema.getDefaultSearchFieldName());
        finfo.add("types", types);
        return finfo;
    }

    private static SimpleOrderedMap<Object> getAnalyzerInfo(Analyzer analyzer) {
        SimpleOrderedMap<Object> aninfo = new SimpleOrderedMap<Object>();
        aninfo.add("className", analyzer.getClass().getName());
        if (analyzer instanceof TokenizerChain) {
            SimpleOrderedMap<Object> tokenizer = new SimpleOrderedMap<Object>();
            TokenizerChain tchain = (TokenizerChain)analyzer;
            TokenizerFactory tfac = tchain.getTokenizerFactory();
            tokenizer.add("className", tfac.getClass().getName());
            tokenizer.add("args", tfac.getArgs());
            aninfo.add("tokenizer", tokenizer);
            TokenFilterFactory[] filtfacs = tchain.getTokenFilterFactories();
            SimpleOrderedMap filters = new SimpleOrderedMap();
            for (TokenFilterFactory filtfac : filtfacs) {
                HashMap<String, Object> tok = new HashMap<String, Object>();
                String className = filtfac.getClass().getName();
                tok.put("className", className);
                tok.put("args", filtfac.getArgs());
                filters.add(className.substring(className.lastIndexOf(46) + 1), tok);
            }
            if (filters.size() > 0) {
                aninfo.add("filters", filters);
            }
        }
        return aninfo;
    }

    private static void populateFieldInfo(IndexSchema schema, Map<String, List<String>> typeusemap, SimpleOrderedMap<Object> fields, SchemaField uniqueField, SchemaField f) {
        FieldType ft = f.getType();
        SimpleOrderedMap<Object> field = new SimpleOrderedMap<Object>();
        field.add("type", ft.getTypeName());
        field.add("flags", LukeRequestHandler.getFieldFlags(f));
        if (f.isRequired()) {
            field.add("required", f.isRequired());
        }
        if (f.getDefaultValue() != null) {
            field.add("default", f.getDefaultValue());
        }
        if (f == uniqueField) {
            field.add("uniqueKey", true);
        }
        if (ft.getAnalyzer().getPositionIncrementGap(f.getName()) != 0) {
            field.add("positionIncrementGap", ft.getAnalyzer().getPositionIncrementGap(f.getName()));
        }
        field.add("copyDests", schema.getCopyFields(f.getName()));
        field.add("copySources", schema.getCopySources(f.getName()));
        fields.add(f.getName(), field);
        List<String> v = typeusemap.get(ft.getTypeName());
        if (v == null) {
            v = new ArrayList<String>();
        }
        v.add(f.getName());
        typeusemap.put(ft.getTypeName(), v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SimpleOrderedMap<Object> getIndexInfo(IndexReader reader, boolean countTerms) throws IOException {
        SimpleOrderedMap<Object> indexInfo;
        Directory dir;
        block5: {
            dir = reader.directory();
            indexInfo = new SimpleOrderedMap<Object>();
            indexInfo.add("numDocs", reader.numDocs());
            indexInfo.add("maxDoc", reader.maxDoc());
            if (countTerms) {
                TermEnum te = null;
                try {
                    te = reader.terms();
                    int numTerms = 0;
                    while (te.next()) {
                        ++numTerms;
                    }
                    indexInfo.add(NUMTERMS, numTerms);
                    Object var7_6 = null;
                    if (te == null) break block5;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (te != null) {
                        te.close();
                    }
                    throw throwable;
                }
                te.close();
            }
        }
        indexInfo.add("version", reader.getVersion());
        indexInfo.add("optimized", reader.isOptimized());
        indexInfo.add("current", reader.isCurrent());
        indexInfo.add("hasDeletions", reader.hasDeletions());
        indexInfo.add("directory", dir);
        indexInfo.add("lastModified", new Date(IndexReader.lastModified(dir)));
        return indexInfo;
    }

    @Override
    public String getDescription() {
        return "Lucene Index Browser.  Inspired and modeled after Luke: http://www.getopt.org/luke/";
    }

    @Override
    public String getVersion() {
        return "$Revision: 949889 $";
    }

    @Override
    public String getSourceId() {
        return "$Id: LukeRequestHandler.java 949889 2010-05-31 23:27:44Z hossman $";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.4/src/java/org/apache/solr/handler/admin/LukeRequestHandler.java $";
    }

    @Override
    public URL[] getDocs() {
        try {
            return new URL[]{new URL("http://wiki.apache.org/solr/LukeRequestHandler")};
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, TopTermQueue> getTopTerms(IndexReader reader, Set<String> fields, int numTerms, Set<String> junkWords) throws Exception {
        HashMap<String, TopTermQueue> info = new HashMap<String, TopTermQueue>();
        TermEnum terms = null;
        try {
            terms = reader.terms();
            while (terms.next()) {
                String field = terms.term().field();
                String t = terms.term().text();
                TopTermQueue tiq = (TopTermQueue)info.get(field);
                if (tiq == null) {
                    tiq = new TopTermQueue(numTerms + 1);
                    info.put(field, tiq);
                }
                ++tiq.distinctTerms;
                tiq.histogram.add(terms.docFreq());
                if (fields != null && fields.size() > 0 && !fields.contains(field) || junkWords != null && junkWords.contains(t) || terms.docFreq() <= tiq.minFreq) continue;
                tiq.put(new TopTermQueue.TermInfo(terms.term(), terms.docFreq()));
                if (tiq.size() <= numTerms) continue;
                tiq.pop();
                tiq.minFreq = ((TopTermQueue.TermInfo)tiq.top()).docFreq;
            }
            Object var10_9 = null;
            if (terms == null) return info;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (terms == null) throw throwable;
            terms.close();
            throw throwable;
        }
        terms.close();
        return info;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TopTermQueue
    extends PriorityQueue {
        public int minFreq = 0;
        public int distinctTerms = 0;
        public TermHistogram histogram;

        TopTermQueue(int size) {
            this.initialize(size);
            this.histogram = new TermHistogram();
        }

        @Override
        protected final boolean lessThan(Object a, Object b) {
            TermInfo termInfoA = (TermInfo)a;
            TermInfo termInfoB = (TermInfo)b;
            return termInfoA.docFreq < termInfoB.docFreq;
        }

        public NamedList<Integer> toNamedList(IndexSchema schema) {
            LinkedList<TermInfo> aslist = new LinkedList<TermInfo>();
            while (this.size() > 0) {
                aslist.add(0, (TermInfo)this.pop());
            }
            NamedList<Integer> list = new NamedList<Integer>();
            for (TermInfo i : aslist) {
                String txt = i.term.text();
                SchemaField ft = schema.getFieldOrNull(i.term.field());
                if (ft != null) {
                    txt = ft.getType().indexedToReadable(txt);
                }
                list.add(txt, i.docFreq);
            }
            return list;
        }

        static class TermInfo {
            int docFreq;
            Term term;

            TermInfo(Term t, int df) {
                this.term = t;
                this.docFreq = df;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TermHistogram {
        int maxBucket = -1;
        public Map<Integer, Integer> hist = new HashMap<Integer, Integer>();
        private static final double LOG2 = Math.log(2.0);

        TermHistogram() {
        }

        public static int getPowerOfTwoBucket(int num) {
            return Math.max(1, Integer.highestOneBit(num - 1) << 1);
        }

        public void add(int df) {
            Integer old;
            Integer bucket = TermHistogram.getPowerOfTwoBucket(df);
            if (bucket > this.maxBucket) {
                this.maxBucket = bucket;
            }
            if ((old = this.hist.get(bucket)) == null) {
                this.hist.put(bucket, 1);
            } else {
                this.hist.put(bucket, old + 1);
            }
        }

        public NamedList<Integer> toNamedList() {
            NamedList<Integer> nl = new NamedList<Integer>();
            for (int bucket = 1; bucket <= this.maxBucket; bucket *= 2) {
                Integer val = this.hist.get(bucket);
                if (val == null) {
                    val = 0;
                }
                nl.add("" + bucket, val);
            }
            return nl;
        }
    }
}

