/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.solr.analysis.BaseTokenFilterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeNGramFilterFactory
extends BaseTokenFilterFactory {
    private int maxGramSize = 0;
    private int minGramSize = 0;
    private String side;

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        String maxArg = args.get("maxGramSize");
        this.maxGramSize = maxArg != null ? Integer.parseInt(maxArg) : 1;
        String minArg = args.get("minGramSize");
        this.minGramSize = minArg != null ? Integer.parseInt(minArg) : 1;
        this.side = args.get("side");
        if (this.side == null) {
            this.side = EdgeNGramTokenFilter.Side.FRONT.getLabel();
        }
    }

    @Override
    public EdgeNGramTokenFilter create(TokenStream input) {
        return new EdgeNGramTokenFilter(input, this.side, this.minGramSize, this.maxGramSize);
    }
}

