/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.deployer.internal;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.application.deployer.Feature;
import org.wso2.carbon.application.deployer.handler.AppDeploymentHandler;
import org.wso2.carbon.application.deployer.handler.DefaultAppDeployer;
import org.wso2.carbon.application.deployer.handler.RegistryResourceDeployer;
import org.wso2.carbon.application.deployer.internal.ApplicationManager;
import org.wso2.carbon.application.deployer.service.ApplicationManagerService;
import org.wso2.carbon.registry.core.service.RegistryService;

public class AppDeployerServiceComponent {
    private static RegistryService registryService;
    private static BundleContext bundleContext;
    private static ServiceRegistration appManagerRegistration;
    private static Map<String, List<Feature>> requiredFeatures;
    private List<AppDeploymentHandler> appHandlers = new ArrayList<AppDeploymentHandler>();
    private static final Log log;

    protected void activate(ComponentContext ctxt) {
        try {
            bundleContext = ctxt.getBundleContext();
            ApplicationManager applicationManager = ApplicationManager.getInstance();
            applicationManager.registerDeploymentHandler(new RegistryResourceDeployer());
            applicationManager.registerDeploymentHandler(new DefaultAppDeployer());
            for (AppDeploymentHandler handler : this.appHandlers) {
                applicationManager.registerDeploymentHandler(handler);
            }
            appManagerRegistration = ctxt.getBundleContext().registerService(ApplicationManagerService.class.getName(), (Object)applicationManager, null);
            URL reqFeaturesResource = bundleContext.getBundle().getResource("required-features.xml");
            if (reqFeaturesResource != null) {
                InputStream xmlStream = reqFeaturesResource.openStream();
                requiredFeatures = AppDeployerUtils.readRequiredFeaturs(new StAXOMBuilder(xmlStream).getDocumentElement());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Carbon Application Deployer is activated..");
            }
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate Carbon Application Deployer", e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        if (appManagerRegistration != null) {
            appManagerRegistration.unregister();
        }
    }

    protected void setRegistryService(RegistryService regService) {
        registryService = regService;
    }

    protected void unsetRegistryService(RegistryService regService) {
        registryService = null;
    }

    protected void setAppHandler(AppDeploymentHandler handler) {
        this.appHandlers.add(handler);
    }

    protected void unsetAppHandler(AppDeploymentHandler handler) {
        this.appHandlers.remove(handler);
    }

    public static RegistryService getRegistryService() throws Exception {
        if (registryService == null) {
            String msg = "Before activating Carbon Application deployer bundle, an instance of RegistryService should be in existance";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        return registryService;
    }

    public static BundleContext getBundleContext() {
        if (bundleContext == null) {
            log.error((Object)"Application Deployer has not started. Therefore Bundle context is null");
        }
        return bundleContext;
    }

    public static Map<String, List<Feature>> getRequiredFeatures() {
        return requiredFeatures;
    }

    static {
        log = LogFactory.getLog(AppDeployerServiceComponent.class);
    }
}

