/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.deployer.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.application.deployer.CarbonApplication;
import org.wso2.carbon.application.deployer.config.ApplicationConfiguration;
import org.wso2.carbon.application.deployer.config.Artifact;
import org.wso2.carbon.application.deployer.config.CappFile;
import org.wso2.carbon.application.deployer.config.RegistryConfig;
import org.wso2.carbon.application.deployer.handler.AppDeploymentHandler;
import org.wso2.carbon.application.deployer.internal.ApplicationManager;
import org.wso2.carbon.application.deployer.persistence.CarbonAppPersistenceManager;

public class RegistryResourceDeployer
implements AppDeploymentHandler {
    private static final Log log = LogFactory.getLog(RegistryResourceDeployer.class);
    public static final String REGISTRY_RESOURCE_TYPE = "registry/resource";
    public static final String REGISTRY_FILTER_TYPE = "lib/registry/filter";
    public static final String REGISTRY_HANDLER_TYPE = "lib/registry/handler";

    @Override
    public void deployArtifacts(CarbonApplication carbonApp, AxisConfiguration axisConfig) {
        ApplicationConfiguration appConfig = carbonApp.getAppConfig();
        List<Artifact.Dependency> deps = appConfig.getApplicationArtifact().getDependencies();
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (Artifact.Dependency dep : deps) {
            if (dep.getArtifact() == null) continue;
            artifacts.add(dep.getArtifact());
        }
        CarbonAppPersistenceManager capm = ApplicationManager.getInstance().getPersistenceManager(axisConfig);
        this.deployRegistryArtifacts(capm, artifacts, carbonApp.getAppName());
    }

    @Override
    public void undeployArtifacts(CarbonApplication carbonApp, AxisConfiguration axisConfig) {
        ApplicationConfiguration appConfig = carbonApp.getAppConfig();
        List<Artifact.Dependency> deps = appConfig.getApplicationArtifact().getDependencies();
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (Artifact.Dependency dep : deps) {
            if (dep.getArtifact() == null) continue;
            artifacts.add(dep.getArtifact());
        }
        CarbonAppPersistenceManager capm = ApplicationManager.getInstance().getPersistenceManager(axisConfig);
        this.undeployRegistryArtifacts(capm, artifacts, carbonApp.getAppName());
    }

    private void deployRegistryArtifacts(CarbonAppPersistenceManager capm, List<Artifact> artifacts, String parentAppName) {
        for (Artifact artifact : artifacts) {
            List<Artifact> subArtifacts;
            if (REGISTRY_RESOURCE_TYPE.equals(artifact.getType())) {
                try {
                    RegistryConfig regConfig = this.buildRegistryConfig(artifact);
                    if (regConfig != null) {
                        capm.writeArtifactResources(regConfig);
                    }
                    artifact.setRegConfig(regConfig);
                }
                catch (Exception e) {
                    log.error((Object)("Error while deploying registry artifact " + artifact.getName()), (Throwable)e);
                }
            }
            if ((subArtifacts = artifact.getSubArtifacts()).size() != 0) {
                for (Artifact sub : subArtifacts) {
                    sub.setExtractedPath(artifact.getExtractedPath());
                    sub.setName(artifact.getName());
                }
            }
            this.deployRegistryArtifacts(capm, subArtifacts, parentAppName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegistryConfig buildRegistryConfig(Artifact artifact) {
        RegistryConfig regConfig = null;
        List<CappFile> files = artifact.getFiles();
        if (files.size() == 1) {
            String fileName = artifact.getFiles().get(0).getName();
            String regConfigPath = artifact.getExtractedPath() + File.separator + fileName;
            File f = new File(regConfigPath);
            if (f.exists()) {
                FileInputStream xmlInputStream = null;
                try {
                    xmlInputStream = new FileInputStream(f);
                    regConfig = AppDeployerUtils.populateRegistryConfig(new StAXOMBuilder((InputStream)xmlInputStream).getDocumentElement());
                }
                catch (Exception e) {
                    log.error((Object)("Error while reading file : " + fileName), (Throwable)e);
                }
                finally {
                    if (xmlInputStream != null) {
                        try {
                            ((InputStream)xmlInputStream).close();
                        }
                        catch (IOException e) {
                            log.error((Object)"Error while closing input stream.", (Throwable)e);
                        }
                    }
                }
                if (regConfig != null) {
                    regConfig.setExtractedPath(artifact.getExtractedPath());
                    regConfig.setParentArtifactName(artifact.getName());
                    regConfig.setConfigFileName(fileName);
                }
            } else {
                log.error((Object)("Registry config file not found at : " + regConfigPath));
            }
        } else {
            log.error((Object)("Registry/Resource type must have a single file which declares registry configs. But " + files.size() + " files found."));
        }
        return regConfig;
    }

    private void undeployRegistryArtifacts(CarbonAppPersistenceManager capm, List<Artifact> artifacts, String parentAppName) {
        for (Artifact artifact : artifacts) {
            List<Artifact> subArtifacts;
            if (REGISTRY_RESOURCE_TYPE.equals(artifact.getType())) {
                try {
                    RegistryConfig regConfig = artifact.getRegConfig();
                    if (regConfig == null) {
                        regConfig = capm.loadRegistryConfig("repository/applications/" + parentAppName + "/dependencies/" + artifact.getName());
                    }
                    if (regConfig != null) {
                        capm.removeArtifactResources(regConfig);
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Error while loading registry config for artifact " + artifact.getName()), (Throwable)e);
                }
            }
            if ((subArtifacts = artifact.getSubArtifacts()).size() != 0) {
                for (Artifact sub : subArtifacts) {
                    sub.setName(artifact.getName());
                }
            }
            this.undeployRegistryArtifacts(capm, subArtifacts, parentAppName);
        }
    }
}

