/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.app;

import org.apache.abdera.Abdera;
import org.apache.abdera.protocol.server.CollectionAdapter;
import org.apache.abdera.protocol.server.CollectionInfo;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.TargetBuilder;
import org.apache.abdera.protocol.server.TargetType;
import org.apache.abdera.protocol.server.WorkspaceInfo;
import org.apache.abdera.protocol.server.impl.AbstractWorkspaceProvider;
import org.apache.abdera.protocol.server.impl.SimpleWorkspaceInfo;
import org.apache.abdera.protocol.server.impl.TemplateTargetBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.app.RegistryAdapter;
import org.wso2.carbon.registry.app.RegistryRequestProcessor;
import org.wso2.carbon.registry.app.RegistryResolver;
import org.wso2.carbon.registry.app.Utils;
import org.wso2.carbon.registry.app.targets.ResponseTarget;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.EmbeddedRegistryService;

public class RegistryProvider
extends AbstractWorkspaceProvider {
    private static final Log log = LogFactory.getLog(RegistryProvider.class);
    private RegistryAdapter adapter;
    public static final String BASE_CONTEXT = "/registry";

    public CollectionAdapter getCollectionAdapter(RequestContext request) {
        return this.adapter;
    }

    public RegistryProvider(Abdera abdera) throws Exception {
        EmbeddedRegistryService embeddedRegistryService;
        RegistryContext context = RegistryContext.getBaseInstance();
        if (context == null) {
            String msg = "Registry is not properly initialized. Registry context is not found.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        TargetType[] types = new TargetType[]{RegistryResolver.TAGS_TYPE, RegistryResolver.LOGS_TYPE, RegistryResolver.RATINGS_TYPE, RegistryResolver.COMMENTS_TYPE, RegistryResolver.RENAME_TYPE, RegistryResolver.COPY_TYPE, RegistryResolver.MOVE_TYPE, RegistryResolver.TAG_URL_TYPE, RegistryResolver.ASSOCIATIONS_TYPE, RegistryResolver.RESTORE_TYPE, RegistryResolver.VERSIONS_TYPE, RegistryResolver.CHECKPOINT_TYPE, RegistryResolver.QUERY_TYPE, RegistryResolver.IMPORT_TYPE, RegistryResolver.DUMP_TYPE, RegistryResolver.COLLECTION_CUSTOM_TYPE, RegistryResolver.DELETE_TYPE, RegistryResolver.ASPECT_TYPE, ResponseTarget.RESPONSE_TYPE};
        RegistryRequestProcessor processor = new RegistryRequestProcessor();
        for (TargetType type : types) {
            this.requestProcessors.put(type, processor);
        }
        try {
            embeddedRegistryService = Utils.getEmbeddedRegistryService();
        }
        catch (RegistryException e) {
            embeddedRegistryService = context.getEmbeddedRegistryService();
        }
        RegistryResolver resolver = new RegistryResolver(embeddedRegistryService, BASE_CONTEXT);
        this.adapter = new RegistryAdapter();
        this.setTargetResolver(resolver);
        this.setTargetBuilder((TargetBuilder)new TemplateTargetBuilder().setTemplate((Object)TargetType.TYPE_COLLECTION, "{target_base}/atom/{collection}").setTemplate((Object)RegistryResolver.TAGS_TYPE, "{target_base}/atom/{collection};tags"));
        SimpleWorkspaceInfo workspace = new SimpleWorkspaceInfo();
        workspace.setTitle("A Simple Workspace");
        workspace.addCollection((CollectionInfo)this.adapter);
        this.addWorkspace((WorkspaceInfo)workspace);
    }
}

