/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jaqu;

import org.h2.jaqu.SQLStatement;
import org.h2.jaqu.SelectTable;
import org.h2.jaqu.TableDefinition;

class SelectColumn<T> {
    private SelectTable<T> selectTable;
    private TableDefinition.FieldDefinition fieldDef;

    SelectColumn(SelectTable<T> selectTable, TableDefinition.FieldDefinition fieldDefinition) {
        this.selectTable = selectTable;
        this.fieldDef = fieldDefinition;
    }

    void appendSQL(SQLStatement sQLStatement) {
        if (this.selectTable.getQuery().isJoin()) {
            sQLStatement.appendSQL(this.selectTable.getAs() + "." + this.fieldDef.columnName);
        } else {
            sQLStatement.appendSQL(this.fieldDef.columnName);
        }
    }

    TableDefinition.FieldDefinition getFieldDefinition() {
        return this.fieldDef;
    }

    SelectTable<T> getSelectTable() {
        return this.selectTable;
    }

    Object getCurrentValue() {
        return this.fieldDef.getValue(this.selectTable.getCurrent());
    }
}

