/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.caching;

import java.io.Serializable;
import net.sf.jsr107cache.CacheException;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.caching.core.CacheInvalidator;
import org.wso2.carbon.core.caching.InvalidateCacheEntryMessage;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;

public class CacheInvalidationService
implements CacheInvalidator {
    protected CarbonCoreDataHolder dataHolder = CarbonCoreDataHolder.getInstance();
    private static Log log = LogFactory.getLog(CacheInvalidationService.class);

    public void invalidateCache(String cacheName, Serializable key) throws CacheException {
        try {
            ClusteringAgent agent;
            ConfigurationContext configContext = this.dataHolder.getMainServerConfigContext();
            if (configContext != null && configContext.getAxisConfiguration() != null && (agent = configContext.getAxisConfiguration().getClusteringAgent()) != null) {
                InvalidateCacheEntryMessage msg = new InvalidateCacheEntryMessage(cacheName, key);
                agent.sendMessage((ClusteringMessage)msg, true);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed sending cluster invalidation" + e.getMessage()), (Throwable)e);
            throw new CacheException("Failed sending cluster invalidation" + e.getMessage(), (Throwable)e);
        }
    }
}

