/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataSource;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.builder.SOAPBuilder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.format.DataSourceMessageBuilder;
import org.apache.axis2.format.TextMessageBuilder;
import org.apache.axis2.format.TextMessageBuilderAdapter;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.transport.jms.iowrappers.BytesMessageDataSource;
import org.apache.axis2.transport.jms.iowrappers.BytesMessageInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSUtils
extends BaseUtils {
    private static final Log log = LogFactory.getLog(JMSUtils.class);
    private static final Class<?>[] NOARGS = new Class[0];
    private static final Object[] NOPARMS = new Object[0];

    public static boolean isJMSService(AxisService service) {
        if (service.isEnableAllTransports()) {
            return true;
        }
        for (String transport : service.getExposedTransports()) {
            if (!"jms".equals(transport)) continue;
            return true;
        }
        return false;
    }

    public static String getProperty(Message message, String property) {
        try {
            return message.getStringProperty(property);
        }
        catch (JMSException e) {
            return null;
        }
    }

    public static String getDestination(String url) {
        String tempUrl = url.substring("jms:/".length());
        int propPos = tempUrl.indexOf("?");
        if (propPos == -1) {
            return tempUrl;
        }
        return tempUrl.substring(0, propPos);
    }

    public static void setSOAPEnvelope(Message message, MessageContext msgContext, String contentType) throws AxisFault, JMSException {
        OMElement documentElement;
        int index;
        String type;
        Builder builder;
        if (contentType == null) {
            contentType = message instanceof TextMessage ? "text/plain" : "application/octet-stream";
            if (log.isDebugEnabled()) {
                log.debug((Object)("No content type specified; assuming " + contentType));
            }
        }
        if ((builder = BuilderUtil.getBuilderFromSelector((String)(type = (index = contentType.indexOf(59)) > 0 ? contentType.substring(0, index) : contentType), (MessageContext)msgContext)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No message builder found for type '" + type + "'. Falling back to SOAP."));
            }
            builder = new SOAPBuilder();
        }
        if (message instanceof BytesMessage) {
            String charSetEnc = null;
            try {
                if (contentType != null) {
                    charSetEnc = new ContentType(contentType).getParameter("charset");
                }
            }
            catch (ParseException ex) {
                // empty catch block
            }
            msgContext.setProperty("CHARACTER_SET_ENCODING", charSetEnc);
            documentElement = builder instanceof DataSourceMessageBuilder ? ((DataSourceMessageBuilder)builder).processDocument((DataSource)new BytesMessageDataSource((BytesMessage)message), contentType, msgContext) : builder.processDocument((InputStream)new BytesMessageInputStream((BytesMessage)message), contentType, msgContext);
        } else if (message instanceof TextMessage) {
            Object textMessageBuilder = builder instanceof TextMessageBuilder ? (TextMessageBuilder)builder : new TextMessageBuilderAdapter(builder);
            String content = ((TextMessage)message).getText();
            documentElement = textMessageBuilder.processDocument(content, contentType, msgContext);
        } else {
            JMSUtils.handleException((String)("Unsupported JMS message type " + message.getClass().getName()));
            return;
        }
        msgContext.setEnvelope(TransportUtils.createSOAPEnvelope((OMElement)documentElement));
    }

    public static Destination setReplyDestination(Destination replyDestination, Session session, Message message) {
        if (replyDestination == null) {
            try {
                replyDestination = JMSUtils.createTemporaryDestination(session);
            }
            catch (JMSException e) {
                JMSUtils.handleException((String)"Error creating temporary queue for response", (Exception)((Object)e));
            }
        }
        try {
            message.setJMSReplyTo(replyDestination);
        }
        catch (JMSException e) {
            log.warn((Object)("Error setting JMS ReplyTo destination to : " + replyDestination), (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            try {
                assert (replyDestination != null);
                log.debug((Object)("Expecting a response to JMS Destination : " + (replyDestination instanceof Queue ? ((Queue)replyDestination).getQueueName() : ((Topic)replyDestination).getTopicName())));
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        return replyDestination;
    }

    public static void setTransportHeaders(MessageContext msgContext, Message message) throws JMSException {
        Map headerMap = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
        if (headerMap == null) {
            return;
        }
        for (Object headerName : headerMap.keySet()) {
            String name = (String)headerName;
            if (name.startsWith("JMSX") && !name.equals("JMSXGroupID") && !name.equals("JMSXGroupSeq")) continue;
            if ("JMS_COORELATION_ID".equals(name)) {
                message.setJMSCorrelationID((String)headerMap.get("JMS_COORELATION_ID"));
                continue;
            }
            if ("JMS_DELIVERY_MODE".equals(name)) {
                Object o = headerMap.get("JMS_DELIVERY_MODE");
                if (o instanceof Integer) {
                    message.setJMSDeliveryMode(((Integer)o).intValue());
                    continue;
                }
                if (o instanceof String) {
                    try {
                        message.setJMSDeliveryMode(Integer.parseInt((String)o));
                    }
                    catch (NumberFormatException nfe) {
                        log.warn((Object)("Invalid delivery mode ignored : " + o), (Throwable)nfe);
                    }
                    continue;
                }
                log.warn((Object)("Invalid delivery mode ignored : " + o));
                continue;
            }
            if ("JMS_EXPIRATION".equals(name)) {
                message.setJMSExpiration(Long.parseLong((String)headerMap.get("JMS_EXPIRATION")));
                continue;
            }
            if ("JMS_MESSAGE_ID".equals(name)) {
                message.setJMSMessageID((String)headerMap.get("JMS_MESSAGE_ID"));
                continue;
            }
            if ("JMS_PRIORITY".equals(name)) {
                message.setJMSPriority(Integer.parseInt((String)headerMap.get("JMS_PRIORITY")));
                continue;
            }
            if ("JMS_TIMESTAMP".equals(name)) {
                message.setJMSTimestamp(Long.parseLong((String)headerMap.get("JMS_TIMESTAMP")));
                continue;
            }
            if ("JMS_MESSAGE_TYPE".equals(name)) {
                message.setJMSType((String)headerMap.get("JMS_MESSAGE_TYPE"));
                continue;
            }
            Object value = headerMap.get(name);
            if (value instanceof String) {
                message.setStringProperty(name, (String)value);
                continue;
            }
            if (value instanceof Boolean) {
                message.setBooleanProperty(name, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Integer) {
                message.setIntProperty(name, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof Long) {
                message.setLongProperty(name, ((Long)value).longValue());
                continue;
            }
            if (value instanceof Double) {
                message.setDoubleProperty(name, ((Double)value).doubleValue());
                continue;
            }
            if (!(value instanceof Float)) continue;
            message.setFloatProperty(name, ((Float)value).floatValue());
        }
    }

    public static void loadTransportHeaders(Message message, MessageContext responseMsgCtx) throws AxisFault {
        responseMsgCtx.setProperty("TRANSPORT_HEADERS", JMSUtils.getTransportHeaders(message));
    }

    public static Map<String, Object> getTransportHeaders(Message message) {
        Destination dest;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (message.getJMSCorrelationID() != null) {
                map.put("JMS_COORELATION_ID", message.getJMSCorrelationID());
            }
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        try {
            map.put("JMS_DELIVERY_MODE", Integer.toString(message.getJMSDeliveryMode()));
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        try {
            if (message.getJMSDestination() != null) {
                dest = message.getJMSDestination();
                map.put("JMS_DESTINATION", dest instanceof Queue ? ((Queue)dest).getQueueName() : ((Topic)dest).getTopicName());
            }
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        try {
            map.put("JMS_EXPIRATION", Long.toString(message.getJMSExpiration()));
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        try {
            if (message.getJMSMessageID() != null) {
                map.put("JMS_MESSAGE_ID", message.getJMSMessageID());
            }
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        try {
            map.put("JMS_PRIORITY", Long.toString(message.getJMSPriority()));
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        try {
            map.put("JMS_REDELIVERED", Boolean.toString(message.getJMSRedelivered()));
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        try {
            if (message.getJMSReplyTo() != null) {
                dest = message.getJMSReplyTo();
                map.put("JMS_REPLY_TO", dest instanceof Queue ? ((Queue)dest).getQueueName() : ((Topic)dest).getTopicName());
            }
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        try {
            map.put("JMS_TIMESTAMP", Long.toString(message.getJMSTimestamp()));
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        try {
            if (message.getJMSType() != null) {
                map.put("JMS_TYPE", message.getJMSType());
            }
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        Enumeration e = null;
        try {
            e = message.getPropertyNames();
        }
        catch (JMSException ignore) {
            // empty catch block
        }
        if (e != null) {
            while (e.hasMoreElements()) {
                String headerName = (String)e.nextElement();
                try {
                    map.put(headerName, message.getStringProperty(headerName));
                }
                catch (JMSException ignore) {
                    try {
                        map.put(headerName, message.getBooleanProperty(headerName));
                    }
                    catch (JMSException ignore2) {
                        try {
                            map.put(headerName, message.getIntProperty(headerName));
                        }
                        catch (JMSException ignore3) {
                            try {
                                map.put(headerName, message.getLongProperty(headerName));
                            }
                            catch (JMSException ignore4) {
                                try {
                                    map.put(headerName, message.getDoubleProperty(headerName));
                                }
                                catch (JMSException ignore5) {
                                    try {
                                        map.put(headerName, Float.valueOf(message.getFloatProperty(headerName)));
                                    }
                                    catch (JMSException ignore6) {}
                                }
                            }
                        }
                    }
                }
            }
        }
        return map;
    }

    public static MessageConsumer createConsumer(Session session, Destination dest, String messageSelector) throws JMSException {
        if (dest instanceof Queue) {
            return ((QueueSession)session).createReceiver((Queue)dest, messageSelector);
        }
        return ((TopicSession)session).createSubscriber((Topic)dest, messageSelector, false);
    }

    public static Destination createTemporaryDestination(Session session) throws JMSException {
        if (session instanceof QueueSession) {
            return session.createTemporaryQueue();
        }
        return session.createTemporaryTopic();
    }

    public static long getBodyLength(BytesMessage bMsg) {
        block6: {
            try {
                Method mtd = bMsg.getClass().getMethod("getBodyLength", NOARGS);
                if (mtd != null) {
                    return (Long)mtd.invoke((Object)bMsg, NOPARMS);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block6;
                log.debug((Object)"Error trying to determine JMS BytesMessage body length", (Throwable)e);
            }
        }
        long length = 0L;
        try {
            byte[] buffer = new byte[2048];
            bMsg.reset();
            int bytesRead = bMsg.readBytes(buffer);
            while (bytesRead != -1) {
                length += (long)bytesRead;
                bytesRead = bMsg.readBytes(buffer);
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return length;
    }

    public static long getMessageSize(Message message) throws JMSException {
        if (message instanceof BytesMessage) {
            return JMSUtils.getBodyLength((BytesMessage)message);
        }
        if (message instanceof TextMessage) {
            return ((TextMessage)message).getText().getBytes().length;
        }
        log.warn((Object)("Can't determine size of JMS message; unsupported message type : " + message.getClass().getName()));
        return 0L;
    }

    public static <T> T lookup(Context context, Class<T> clazz, String name) throws NamingException {
        Object object = context.lookup(name);
        try {
            return clazz.cast(object);
        }
        catch (ClassCastException ex) {
            if (object instanceof Reference) {
                Reference ref = (Reference)object;
                JMSUtils.handleException((String)("JNDI failed to de-reference Reference with name " + name + "; is the factory " + ref.getFactoryClassName() + " in your classpath?"));
                return null;
            }
            JMSUtils.handleException((String)("JNDI lookup of name " + name + " returned a " + object.getClass().getName() + " while a " + clazz + " was expected"));
            return null;
        }
    }

    public static Connection createConnection(ConnectionFactory conFac, String user, String pass, boolean jmsSpec11, Boolean isQueue, boolean isDurable, String clientID) throws JMSException {
        Connection connection = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating a " + (isQueue == null ? "Generic" : (isQueue != false ? "Queue" : "Topic")) + "Connection using credentials : (" + user + "/" + pass + ")"));
        }
        if (jmsSpec11 || isQueue == null) {
            connection = user != null && pass != null ? conFac.createConnection(user, pass) : conFac.createConnection();
            if (isDurable) {
                connection.setClientID(clientID);
            }
        } else {
            QueueConnectionFactory qConFac = null;
            TopicConnectionFactory tConFac = null;
            if (isQueue.booleanValue()) {
                qConFac = (QueueConnectionFactory)conFac;
            } else {
                tConFac = (TopicConnectionFactory)conFac;
            }
            if (user != null && pass != null) {
                if (qConFac != null) {
                    connection = qConFac.createQueueConnection(user, pass);
                } else if (tConFac != null) {
                    connection = tConFac.createTopicConnection(user, pass);
                }
            } else if (qConFac != null) {
                connection = qConFac.createQueueConnection();
            } else if (tConFac != null) {
                connection = tConFac.createTopicConnection();
            }
            if (isDurable) {
                connection.setClientID(clientID);
            }
        }
        return connection;
    }

    public static Session createSession(Connection connection, boolean transacted, int ackMode, boolean jmsSpec11, Boolean isQueue) throws JMSException {
        if (jmsSpec11 || isQueue == null) {
            return connection.createSession(transacted, ackMode);
        }
        if (isQueue.booleanValue()) {
            return ((QueueConnection)connection).createQueueSession(transacted, ackMode);
        }
        return ((TopicConnection)connection).createTopicSession(transacted, ackMode);
    }

    public static MessageConsumer createConsumer(Session session, Destination destination, Boolean isQueue, String subscriberName, String messageSelector, boolean pubSubNoLocal, boolean isDurable, boolean jmsSpec11) throws JMSException {
        if (jmsSpec11 || isQueue == null) {
            if (isDurable) {
                return session.createDurableSubscriber((Topic)destination, subscriberName, messageSelector, pubSubNoLocal);
            }
            return session.createConsumer(destination, messageSelector, pubSubNoLocal);
        }
        if (isQueue.booleanValue()) {
            return ((QueueSession)session).createReceiver((Queue)destination, messageSelector);
        }
        if (isDurable) {
            return ((TopicSession)session).createDurableSubscriber((Topic)destination, subscriberName, messageSelector, pubSubNoLocal);
        }
        return ((TopicSession)session).createSubscriber((Topic)destination, messageSelector, pubSubNoLocal);
    }

    public static MessageProducer createProducer(Session session, Destination destination, Boolean isQueue, boolean jmsSpec11) throws JMSException {
        if (jmsSpec11 || isQueue == null) {
            return session.createProducer(destination);
        }
        if (isQueue.booleanValue()) {
            return ((QueueSession)session).createSender((Queue)destination);
        }
        return ((TopicSession)session).createPublisher((Topic)destination);
    }

    public static String getDestinationTypeAsString(int destType) {
        if (destType == 1) {
            return "queue";
        }
        if (destType == 2) {
            return "topic";
        }
        return "generic";
    }

    public static Destination lookupDestination(Context context, String destinationName, String destinationType) throws NamingException {
        if (destinationName == null) {
            return null;
        }
        try {
            return JMSUtils.lookup(context, Destination.class, destinationName);
        }
        catch (NameNotFoundException e) {
            try {
                return JMSUtils.lookup(context, Destination.class, ("topic".equalsIgnoreCase(destinationType) ? "dynamicTopics/" : "dynamicQueues/") + destinationName);
            }
            catch (NamingException x) {
                log.warn((Object)("Cannot locate destination : " + destinationName));
                throw x;
            }
        }
        catch (NamingException e) {
            log.warn((Object)("Cannot locate destination : " + destinationName), (Throwable)e);
            throw e;
        }
    }
}

