/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import java.io.File;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.equinox.http.servlet.internal.HttpServletRequestAdaptor;
import org.osgi.service.http.HttpContext;

public class ProxyContext {
    private static final String JAVAX_SERVLET_CONTEXT_TEMPDIR = "javax.servlet.context.tempdir";
    private String servletPath;
    private HashMap attributesMap = new HashMap();
    File proxyContextTempDir;

    public ProxyContext(ServletContext servletContext) {
        File tempDir = (File)servletContext.getAttribute(JAVAX_SERVLET_CONTEXT_TEMPDIR);
        if (tempDir != null) {
            this.proxyContextTempDir = new File(tempDir, "proxytemp");
            ProxyContext.deleteDirectory(this.proxyContextTempDir);
            this.proxyContextTempDir.mkdirs();
        }
    }

    public void destroy() {
        if (this.proxyContextTempDir != null) {
            ProxyContext.deleteDirectory(this.proxyContextTempDir);
        }
    }

    synchronized void initializeServletPath(HttpServletRequest req) {
        if (this.servletPath == null) {
            this.servletPath = HttpServletRequestAdaptor.getDispatchServletPath(req);
        }
    }

    synchronized String getServletPath() {
        return this.servletPath;
    }

    synchronized void createContextAttributes(HttpContext httpContext) {
        ContextAttributes attributes = (ContextAttributes)this.attributesMap.get(httpContext);
        if (attributes == null) {
            attributes = new ContextAttributes(httpContext);
            this.attributesMap.put(httpContext, attributes);
        }
        attributes.addReference();
    }

    synchronized void destroyContextAttributes(HttpContext httpContext) {
        ContextAttributes attributes = (ContextAttributes)this.attributesMap.get(httpContext);
        attributes.removeReference();
        if (attributes.referenceCount() == 0) {
            this.attributesMap.remove(httpContext);
            attributes.destroy();
        }
    }

    synchronized Dictionary getContextAttributes(HttpContext httpContext) {
        return (Dictionary)this.attributesMap.get(httpContext);
    }

    protected static boolean deleteDirectory(File directory) {
        if (directory.exists() && directory.isDirectory()) {
            File[] files = directory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    ProxyContext.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return directory.delete();
    }

    public class ContextAttributes
    extends Hashtable {
        private static final long serialVersionUID = 1916670423277243587L;
        private int referenceCount;

        public ContextAttributes(HttpContext httpContext) {
            if (ProxyContext.this.proxyContextTempDir != null) {
                File contextTempDir = new File(ProxyContext.this.proxyContextTempDir, "hc_" + httpContext.hashCode());
                contextTempDir.mkdirs();
                this.put(ProxyContext.JAVAX_SERVLET_CONTEXT_TEMPDIR, contextTempDir);
            }
        }

        public void destroy() {
            File contextTempDir = (File)this.get(ProxyContext.JAVAX_SERVLET_CONTEXT_TEMPDIR);
            if (contextTempDir != null) {
                ProxyContext.deleteDirectory(contextTempDir);
            }
        }

        public void addReference() {
            ++this.referenceCount;
        }

        public void removeReference() {
            --this.referenceCount;
        }

        public int referenceCount() {
            return this.referenceCount;
        }
    }
}

