/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ndatasource.core;

import java.util.ArrayList;
import java.util.List;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.core.CarbonDataSource;
import org.wso2.carbon.ndatasource.core.DataSourceManager;
import org.wso2.carbon.ndatasource.core.DataSourceMetaInfo;

public class DataSourceService {
    public List<CarbonDataSource> getAllDataSources() throws DataSourceException {
        return new ArrayList<CarbonDataSource>(DataSourceManager.getInstance().getDataSourceRepository().getAllDataSources());
    }

    public List<CarbonDataSource> getAllDataSourcesForType(String dsType) throws DataSourceException {
        ArrayList<CarbonDataSource> result = new ArrayList<CarbonDataSource>();
        for (CarbonDataSource cds : DataSourceManager.getInstance().getDataSourceRepository().getAllDataSources()) {
            if (!dsType.equals(cds.getDSMInfo().getDefinition().getType())) continue;
            result.add(cds);
        }
        return result;
    }

    public CarbonDataSource getDataSource(String dsName) throws DataSourceException {
        return DataSourceManager.getInstance().getDataSourceRepository().getDataSource(dsName);
    }

    public List<String> getDataSourceTypes() throws DataSourceException {
        return DataSourceManager.getInstance().getDataSourceTypes();
    }

    public void reloadAllDataSources() throws DataSourceException {
        DataSourceManager.getInstance().getDataSourceRepository().refreshAllUserDataSources();
    }

    public void reloadDataSource(String dsName) throws DataSourceException {
        DataSourceManager.getInstance().getDataSourceRepository().refreshUserDataSource(dsName);
    }

    public void addDataSource(DataSourceMetaInfo dsmInfo) throws DataSourceException {
        DataSourceManager.getInstance().getDataSourceRepository().addDataSource(dsmInfo);
    }

    public void deleteDataSource(String dsName) throws DataSourceException {
        DataSourceManager.getInstance().getDataSourceRepository().deleteDataSource(dsName);
    }
}

