/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.poi.hwpf.model.GenericPropertyNode;
import org.apache.poi.hwpf.model.PAPFormattedDiskPage;
import org.apache.poi.hwpf.model.PAPX;
import org.apache.poi.hwpf.model.PlexOfCps;
import org.apache.poi.hwpf.model.PropertyNode;
import org.apache.poi.hwpf.model.TextPieceTable;
import org.apache.poi.hwpf.model.io.HWPFFileSystem;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.hwpf.sprm.SprmBuffer;
import org.apache.poi.util.LittleEndian;

public final class PAPBinTable {
    protected ArrayList _paragraphs = new ArrayList();
    byte[] _dataStream;
    private TextPieceTable tpt;

    public PAPBinTable() {
    }

    public PAPBinTable(byte[] documentStream, byte[] tableStream, byte[] dataStream, int offset, int size, int fcMin, TextPieceTable tpt) {
        PlexOfCps binTable = new PlexOfCps(tableStream, offset, size, 4);
        this.tpt = tpt;
        int length = binTable.length();
        for (int x = 0; x < length; ++x) {
            GenericPropertyNode node = binTable.getProperty(x);
            int pageNum = LittleEndian.getInt(node.getBytes());
            int pageOffset = 512 * pageNum;
            PAPFormattedDiskPage pfkp = new PAPFormattedDiskPage(documentStream, dataStream, pageOffset, fcMin, tpt);
            int fkpSize = pfkp.size();
            for (int y = 0; y < fkpSize; ++y) {
                PAPX papx = pfkp.getPAPX(y);
                this._paragraphs.add(papx);
            }
        }
        this._dataStream = dataStream;
    }

    public void insert(int listIndex, int cpStart, SprmBuffer buf) {
        PAPX forInsert = new PAPX(0, 0, this.tpt, buf, this._dataStream);
        forInsert.setStart(cpStart);
        forInsert.setEnd(cpStart);
        if (listIndex == this._paragraphs.size()) {
            this._paragraphs.add(forInsert);
        } else {
            PAPX currentPap = (PAPX)this._paragraphs.get(listIndex);
            if (currentPap != null && currentPap.getStart() < cpStart) {
                SprmBuffer clonedBuf = null;
                try {
                    clonedBuf = (SprmBuffer)currentPap.getSprmBuf().clone();
                }
                catch (CloneNotSupportedException exc) {
                    exc.printStackTrace();
                }
                PAPX clone = new PAPX(0, 0, this.tpt, clonedBuf, this._dataStream);
                clone.setStart(cpStart);
                clone.setEnd(currentPap.getEnd());
                currentPap.setEnd(cpStart);
                this._paragraphs.add(listIndex + 1, forInsert);
                this._paragraphs.add(listIndex + 2, clone);
            } else {
                this._paragraphs.add(listIndex, forInsert);
            }
        }
    }

    public void adjustForDelete(int listIndex, int offset, int length) {
        int x;
        int size = this._paragraphs.size();
        int endMark = offset + length;
        int endIndex = listIndex;
        PAPX papx = (PAPX)this._paragraphs.get(endIndex);
        while (papx.getEnd() < endMark) {
            papx = (PAPX)this._paragraphs.get(++endIndex);
        }
        if (listIndex == endIndex) {
            papx = (PAPX)this._paragraphs.get(endIndex);
            papx.setEnd(papx.getEnd() - endMark + offset);
        } else {
            papx = (PAPX)this._paragraphs.get(listIndex);
            papx.setEnd(offset);
            for (x = listIndex + 1; x < endIndex; ++x) {
                papx = (PAPX)this._paragraphs.get(x);
                papx.setStart(offset);
                papx.setEnd(offset);
            }
            papx = (PAPX)this._paragraphs.get(endIndex);
            papx.setEnd(papx.getEnd() - endMark + offset);
        }
        for (x = endIndex + 1; x < size; ++x) {
            papx = (PAPX)this._paragraphs.get(x);
            papx.setStart(papx.getStart() - length);
            papx.setEnd(papx.getEnd() - length);
        }
    }

    public void adjustForInsert(int listIndex, int length) {
        int size = this._paragraphs.size();
        PAPX papx = (PAPX)this._paragraphs.get(listIndex);
        papx.setEnd(papx.getEnd() + length);
        for (int x = listIndex + 1; x < size; ++x) {
            papx = (PAPX)this._paragraphs.get(x);
            papx.setStart(papx.getStart() + length);
            papx.setEnd(papx.getEnd() + length);
        }
    }

    public ArrayList getParagraphs() {
        return this._paragraphs;
    }

    public void writeTo(HWPFFileSystem sys, int fcMin) throws IOException {
        HWPFOutputStream docStream = sys.getStream("WordDocument");
        HWPFOutputStream tableStream = sys.getStream("1Table");
        PlexOfCps binTable = new PlexOfCps(4);
        int docOffset = docStream.getOffset();
        int mod = docOffset % 512;
        if (mod != 0) {
            byte[] padding = new byte[512 - mod];
            docStream.write(padding);
        }
        docOffset = docStream.getOffset();
        int pageNum = docOffset / 512;
        int endingFc = ((PropertyNode)this._paragraphs.get(this._paragraphs.size() - 1)).getEnd();
        endingFc += fcMin;
        ArrayList overflow = this._paragraphs;
        do {
            PropertyNode startingProp = (PropertyNode)overflow.get(0);
            int start = startingProp.getStart() + fcMin;
            PAPFormattedDiskPage pfkp = new PAPFormattedDiskPage(this._dataStream);
            pfkp.fill(overflow);
            byte[] bufFkp = pfkp.toByteArray(fcMin);
            docStream.write(bufFkp);
            overflow = pfkp.getOverflow();
            int end = endingFc;
            if (overflow != null) {
                end = ((PropertyNode)overflow.get(0)).getStart() + fcMin;
            }
            byte[] intHolder = new byte[4];
            LittleEndian.putInt(intHolder, pageNum++);
            binTable.addProperty(new GenericPropertyNode(start, end, intHolder));
        } while (overflow != null);
        tableStream.write(binTable.toByteArray());
    }
}

