/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.extensions;

import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.wso2.carbon.server.CarbonLaunchExtension;
import org.wso2.carbon.server.util.Utils;

public class SystemBundleExtensionCreator
implements CarbonLaunchExtension {
    private static final String EXTENSIONS_DIR = "repository" + File.separator + "components" + File.separator + "extensions";
    private static final String EXTENSION_PREFIX = "org.wso2.carbon.framework.extension.";

    @Override
    public void perform() {
        File dropinsFolder = new File(Utils.getCarbonComponentRepo(), "dropins");
        File dir = Utils.getBundleDirectory(EXTENSIONS_DIR);
        File[] files = dir.listFiles(new Utils.JarFileFilter());
        if (files != null) {
            for (File file : files) {
                try {
                    Manifest mf = new Manifest();
                    Attributes attribs = mf.getMainAttributes();
                    attribs.putValue("Fragment-Host", "system.bundle; extension:=framework");
                    Utils.createBundle(file, dropinsFolder, mf, EXTENSION_PREFIX);
                }
                catch (IOException e) {
                    System.err.println("Cannot create framework extension bundle from jar file " + file.getAbsolutePath());
                    e.printStackTrace();
                }
            }
        }
    }
}

