/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.server.CarbonLauncher;
import org.wso2.carbon.server.extensions.DefaultBundleCreator;
import org.wso2.carbon.server.extensions.DropinsBundleDeployer;
import org.wso2.carbon.server.extensions.Log4jPropFileFragmentBundleCreator;
import org.wso2.carbon.server.extensions.PatchInstaller;
import org.wso2.carbon.server.extensions.SystemBundleExtensionCreator;
import org.wso2.carbon.server.util.Utils;

public class Main {
    private static Log log = LogFactory.getLog(Main.class);

    public static void main(String[] args) {
        if (System.getProperty("carbon.home") == null) {
            System.setProperty("carbon.home", ".");
        }
        System.setProperty("axis2.home", System.getProperty("carbon.home"));
        System.setProperty("wso2carbon.start.time", System.currentTimeMillis() + "");
        if (System.getProperty("carbon.instance.name") == null) {
            String hostName;
            String ipAddr;
            try {
                InetAddress addr = InetAddress.getLocalHost();
                ipAddr = addr.getHostAddress();
                hostName = addr.getHostName();
            }
            catch (UnknownHostException e) {
                ipAddr = "localhost";
                hostName = "127.0.0.1";
            }
            String uuId = UUID.randomUUID().toString();
            String timeStamp = System.currentTimeMillis() + "";
            String carbon_instance_name = timeStamp + "_" + hostName + "_" + ipAddr + "_" + uuId;
            System.setProperty("carbon.instance.name", carbon_instance_name);
        }
        Main.writePID(System.getProperty("carbon.home"));
        Main.processCmdLineArgs(args);
        Main.invokeExtensions();
        Main.launchCarbon();
    }

    public static void processCmdLineArgs(String[] args) {
        String cmd = null;
        int index = 0;
        for (String arg : args) {
            ++index;
            if (arg.startsWith("-D")) {
                String value;
                String property;
                int indexOfEq = arg.indexOf(61);
                if (indexOfEq != -1) {
                    property = arg.substring(2, indexOfEq);
                    value = arg.substring(indexOfEq + 1);
                } else {
                    property = arg.substring(2);
                    value = "true";
                }
                System.setProperty(property, value);
                continue;
            }
            if (arg.toUpperCase().endsWith("HELP")) {
                Utils.printUsages();
                System.exit(0);
                continue;
            }
            if (arg.toUpperCase().endsWith("CLEANREGISTRY")) {
                System.setProperty("carbon.registry.clean", "true");
                continue;
            }
            if (cmd != null) continue;
            cmd = arg;
        }
    }

    public static void invokeExtensions() {
        new DefaultBundleCreator().perform();
        new SystemBundleExtensionCreator().perform();
        new Log4jPropFileFragmentBundleCreator().perform();
        new DropinsBundleDeployer().perform();
        new PatchInstaller().perform();
    }

    public static void launchCarbon() {
        CarbonLauncher carbonLauncher = new CarbonLauncher();
        carbonLauncher.launch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePID(String carbonHome) {
        Process p;
        byte[] bo = new byte[100];
        String[] cmd = new String[]{"bash", "-c", "echo $PPID"};
        try {
            p = Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            return;
        }
        try {
            int bytes = p.getInputStream().read(bo);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        String pid = new String(bo);
        if (pid.length() != 0) {
            BufferedWriter out = null;
            try {
                FileWriter writer = new FileWriter(carbonHome + File.separator + "wso2carbon.pid");
                out = new BufferedWriter(writer);
                out.write(pid);
            }
            catch (IOException e) {
                log.warn((Object)"Cannot write wso2carbon.pid file");
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
    }
}

