/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jdo;

import java.util.Collection;
import java.util.Iterator;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;
import org.compass.core.CompassSession;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.spi.InternalCompass;
import org.compass.gps.CompassGpsException;
import org.compass.gps.IndexPlan;
import org.compass.gps.device.AbstractGpsDevice;
import org.compass.gps.device.jdo.JdoGpsDeviceException;

public class JdoGpsDevice
extends AbstractGpsDevice {
    protected PersistenceManagerFactory persistenceManagerFactory;

    public JdoGpsDevice() {
    }

    public JdoGpsDevice(String name, PersistenceManagerFactory persistenceManagerFactory) {
        this.setName(name);
        this.persistenceManagerFactory = persistenceManagerFactory;
    }

    protected void doStart() throws CompassGpsException {
        if (this.persistenceManagerFactory == null) {
            throw new IllegalArgumentException(this.buildMessage("persistenceManagerFactory must be set"));
        }
    }

    protected void doIndex(CompassSession session, IndexPlan indexPlan) throws CompassGpsException {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)this.buildMessage("Indexing the database"));
        }
        ResourceMapping[] resourceMappings = ((InternalCompass)this.compassGps.getIndexCompass()).getMapping().getRootMappings();
        for (int i = 0; i < resourceMappings.length; ++i) {
            ClassMapping classMapping;
            Class clazz;
            if (!(resourceMappings[i] instanceof ClassMapping) || this.isFilteredForIndex((clazz = (classMapping = (ClassMapping)resourceMappings[i]).getClazz()).getName())) continue;
            PersistenceManager pm = this.persistenceManagerFactory.getPersistenceManager();
            Transaction tr = pm.currentTransaction();
            try {
                tr.begin();
                Collection datas = null;
                try {
                    Query query = pm.newQuery(clazz);
                    datas = (Collection)query.execute();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (datas == null || datas.size() == 0) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)this.buildMessage("Indexing alias [" + classMapping.getAlias() + "] with object count [" + datas.size() + "]"));
                }
                Iterator it = datas.iterator();
                while (it.hasNext()) {
                    session.create(it.next());
                }
                tr.commit();
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)this.buildMessage("Failed to index the database"), (Throwable)e);
                throw new JdoGpsDeviceException(this.buildMessage("Failed to index the database"), e);
            }
            finally {
                if (tr.isActive()) {
                    tr.rollback();
                }
                pm.close();
            }
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)this.buildMessage("Finished indexing the database"));
        }
    }

    public PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.persistenceManagerFactory;
    }

    public void setPersistenceManagerFactory(PersistenceManagerFactory persistenceManagerFactory) {
        this.persistenceManagerFactory = persistenceManagerFactory;
    }
}

