/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.persistence.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.XMLPrettyPrinter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.wso2.carbon.core.persistence.PersistenceDataNotFoundException;
import org.wso2.carbon.core.persistence.PersistenceException;
import org.wso2.carbon.core.persistence.PersistenceUtils;
import org.wso2.carbon.core.persistence.file.ResourceFileData;
import org.wso2.carbon.utils.CarbonUtils;

public abstract class AbstractFilePersistenceManager {
    protected AxisConfiguration axisConfig;
    File metafilesDir;
    Map<String, ResourceFileData> resourceMap = new HashMap<String, ResourceFileData>();
    private Set<String> userModifiedItems = new HashSet<String>();
    private Set<String> modifyingMetaFiles = new HashSet<String>();
    protected OMFactory omFactory = OMAbstractFactory.getOMFactory();
    private static final Log log = LogFactory.getLog(AbstractFilePersistenceManager.class);

    protected AbstractFilePersistenceManager(AxisConfiguration axisConfig) {
        this.axisConfig = axisConfig;
    }

    public abstract void beginTransaction(String var1) throws IOException, XMLStreamException, PersistenceException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commitTransaction(String resourceId) throws PersistenceException {
        if (!this.isMetaFileModification(resourceId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No metafile modification done for : " + resourceId));
            }
            this.resourceMap.remove(resourceId);
            return;
        }
        if (CarbonUtils.isWorkerNode()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Worker nodes do not need to update metafiles.");
            }
            this.resourceMap.remove(resourceId);
            return;
        }
        try {
            ResourceFileData resourceFileData = this.resourceMap.get(resourceId);
            synchronized (resourceFileData) {
                ResourceFileData fileData = this.resourceMap.get(resourceId);
                if (fileData != null && fileData.getOMElement() == null) {
                    String childFilePath = this.getFilePathFromResourceId(resourceId);
                    File f = new File(this.metafilesDir, childFilePath);
                    if (f.exists()) {
                        FileUtils.forceDelete((File)f);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Successfully deleted persisted resource contents " + resourceId + " " + f.getName()));
                    }
                    this.resourceMap.remove(resourceId);
                    return;
                }
                if (fileData == null) {
                    this.resourceMap.remove(resourceId);
                    throw new PersistenceException("persistence data not found");
                }
                File f = fileData.getFile();
                FileOutputStream outputStream = FileUtils.openOutputStream((File)f);
                fileData.getOMElement().serializeAndConsume((OutputStream)outputStream);
                XMLPrettyPrinter.prettify((File)f);
                this.resourceMap.remove(resourceId);
                this.setUserModification(resourceId);
                ((OutputStream)outputStream).close();
            }
        }
        catch (XMLStreamException e1) {
            log.error((Object)("Exception in persisting the transaction of " + resourceId), (Throwable)e1);
            this.handleExceptionWithRollback(resourceId, "Exception in persisting the transaction " + resourceId, e1);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.handleExceptionWithRollback(resourceId, "IOException in persisting the transaction " + resourceId, e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added new resource - " + resourceId));
        }
    }

    protected String getFilePathFromResourceId(String resourceId) {
        if (resourceId != null) {
            String[] names = resourceId.split("/");
            StringBuilder sb = new StringBuilder(names[0]);
            char fs = File.separatorChar;
            for (int i = 1; i < names.length; ++i) {
                sb.append(fs).append(names[i]);
            }
            return sb.append(".xml").toString();
        }
        return null;
    }

    public void rollbackTransaction(String resourceId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("rollbackTransaction for : " + resourceId));
        }
        this.isMetaFileModification(resourceId);
        ResourceFileData fileData = this.resourceMap.get(resourceId);
        if (fileData != null) {
            fileData.setOMElement(null);
            fileData.setTransactionStarted(false);
        }
    }

    public abstract OMElement get(String var1) throws PersistenceDataNotFoundException;

    public OMNode get(String resourceId, String xpathStr) throws PersistenceDataNotFoundException {
        List list = this.getAll(resourceId, xpathStr);
        if (list.size() > 0) {
            return (OMNode)list.get(0);
        }
        return null;
    }

    public OMAttribute getAttribute(String resourceId, String xpathStr) throws PersistenceDataNotFoundException {
        List list = this.getAll(resourceId, xpathStr);
        if (list.size() > 0) {
            return (OMAttribute)list.get(0);
        }
        return null;
    }

    public void put(String resourceName, OMElement content, String xpathOfParent) throws PersistenceDataNotFoundException {
        block8: {
            try {
                ResourceFileData fileData = this.resourceMap.get(resourceName);
                if (fileData != null) {
                    AXIOMXPath xpathExpr = new AXIOMXPath(xpathOfParent);
                    OMElement sgElement = fileData.getOMElement();
                    OMElement parent = (OMElement)xpathExpr.selectSingleNode((Object)sgElement);
                    if (parent != null) {
                        if (!parent.equals(content.getParent())) {
                            parent.addChild((OMNode)content);
                            this.setMetaFileModification(resourceName);
                        } else {
                            this.setMetaFileModification(resourceName);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Trying add a child to the same parent. " + resourceName + content.toString()));
                            }
                        }
                        break block8;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("parent can not be found - " + resourceName + fileData.getOMElement()));
                    }
                    throw new PersistenceDataNotFoundException("The resource can not be added because Parent could not be found." + resourceName + " The XPath - " + xpathOfParent);
                }
                throw new PersistenceDataNotFoundException("ResourceFileData not found. The Transaction May not have been initialized. see #beginTransaction. " + resourceName + "The xpath used was " + xpathOfParent);
            }
            catch (JaxenException e) {
                log.error((Object)("Error selecting parent in " + resourceName), (Throwable)e);
                throw new PersistenceDataNotFoundException("Error selecting parent in " + resourceName, e);
            }
        }
    }

    public void put(String resourceName, OMAttribute attr, String xpathOfElement) throws PersistenceDataNotFoundException {
        try {
            ResourceFileData fileData = this.resourceMap.get(resourceName);
            if (fileData == null) {
                log.error((Object)("put attr = " + attr.getAttributeType() + attr.getAttributeValue()));
                throw new PersistenceDataNotFoundException("ResourceFileData not found. The Transaction May not have been initialized. see #beginTransaction. " + resourceName + "The xpath used was " + xpathOfElement);
            }
            OMElement sgElement = fileData.getOMElement();
            AXIOMXPath xpathExpr = new AXIOMXPath(xpathOfElement);
            OMElement parent = (OMElement)xpathExpr.selectSingleNode((Object)sgElement);
            parent.addAttribute(attr);
            this.setMetaFileModification(resourceName);
        }
        catch (JaxenException e) {
            log.error((Object)("XPath syntaxt error " + xpathOfElement), (Throwable)e);
            throw new PersistenceDataNotFoundException("XPath syntaxt error for " + resourceName + xpathOfElement, e);
        }
    }

    public boolean fileExists(String resourceId) {
        ResourceFileData fileData = this.resourceMap.get(resourceId);
        if (fileData != null && fileData.isTransactionStarted() && fileData.getFile() != null) {
            return fileData.getFile().exists();
        }
        return new File(this.metafilesDir, this.getFilePathFromResourceId(resourceId)).exists();
    }

    public boolean elementExists(String resourceId, String elementXpathStr) {
        try {
            File f;
            ResourceFileData fileData = this.resourceMap.get(resourceId);
            AXIOMXPath xpathExpr = new AXIOMXPath(elementXpathStr);
            if (fileData != null && fileData.isTransactionStarted() && fileData.getOMElement() != null) {
                return xpathExpr.selectSingleNode((Object)fileData.getOMElement()) != null;
            }
            if ((fileData != null && !fileData.isTransactionStarted() || fileData == null) && (f = new File(this.metafilesDir, this.getFilePathFromResourceId(resourceId))).exists()) {
                OMElement element = PersistenceUtils.getResourceDocumentElement(f);
                return xpathExpr.selectSingleNode((Object)element) != null;
            }
        }
        catch (JaxenException e) {
            log.error((Object)("Xpath error " + elementXpathStr), (Throwable)e);
        }
        catch (XMLStreamException e) {
            log.error((Object)(e.getMessage() + resourceId), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            log.error((Object)(e.getMessage() + resourceId), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)(e.getMessage() + resourceId), (Throwable)e);
        }
        return false;
    }

    public List getAll(String resourceId, String xpathStr) throws PersistenceDataNotFoundException {
        try {
            ResourceFileData fileData = this.resourceMap.get(resourceId);
            if (fileData != null && fileData.isTransactionStarted()) {
                OMElement resourceElement = fileData.getOMElement();
                AXIOMXPath xpathExpr = new AXIOMXPath(xpathStr);
                return xpathExpr.selectNodes((Object)resourceElement);
            }
            File resourceFile = new File(this.metafilesDir, this.getFilePathFromResourceId(resourceId));
            if (resourceFile.exists()) {
                OMElement resourceOMElement = PersistenceUtils.getResourceDocumentElement(resourceFile);
                if (resourceOMElement.getParent() instanceof OMDocument) {
                    resourceOMElement.detach();
                }
                AXIOMXPath xpathExpr = new AXIOMXPath(xpathStr);
                return xpathExpr.selectNodes((Object)resourceOMElement);
            }
        }
        catch (JaxenException e) {
            log.error((Object)("Error parsing xpath string " + resourceId + xpathStr), (Throwable)e);
            throw new PersistenceDataNotFoundException("Error parsing xpath string ", e);
        }
        catch (IOException e) {
            log.error((Object)("metafile for resource " + resourceId + " not found. "), (Throwable)e);
            throw new PersistenceDataNotFoundException("metafile for resource " + resourceId + " not found. ", e);
        }
        catch (XMLStreamException e) {
            log.error((Object)("XMLStreamException " + resourceId + " not found. "), (Throwable)e);
            throw new PersistenceDataNotFoundException("XMLStreamException " + resourceId + " not found. ", e);
        }
        return new ArrayList(0);
    }

    public boolean delete(String resourceId, String xpathStr) {
        ResourceFileData fileData = this.resourceMap.get(resourceId);
        try {
            if (fileData != null && fileData.isTransactionStarted()) {
                AXIOMXPath xpathExpr = new AXIOMXPath(xpathStr);
                OMElement sgElement = fileData.getOMElement();
                OMElement el = (OMElement)xpathExpr.selectSingleNode((Object)sgElement);
                if (el == null) {
                    return false;
                }
                if (el.getParent() == null) {
                    fileData.setOMElement(null);
                } else {
                    el.detach();
                }
                this.setMetaFileModification(resourceId);
                return true;
            }
            log.error((Object)("The Element specified by path not found or a transaction isn't started yet. " + xpathStr));
            return false;
        }
        catch (JaxenException e) {
            log.error((Object)("Error parsing xpath string " + resourceId + xpathStr), (Throwable)e);
            return false;
        }
    }

    public boolean deleteAll(String resourceId, String xpathStr) {
        ResourceFileData fileData = this.resourceMap.get(resourceId);
        try {
            if (fileData != null && fileData.isTransactionStarted()) {
                AXIOMXPath xpathExpr = new AXIOMXPath(xpathStr);
                OMElement sgElement = fileData.getOMElement();
                List nodeList = xpathExpr.selectNodes((Object)sgElement);
                if (nodeList == null || nodeList.isEmpty()) {
                    return false;
                }
                for (Object obj : nodeList) {
                    OMElement el = (OMElement)obj;
                    if (el.getParent() == null) {
                        fileData.setOMElement(null);
                        continue;
                    }
                    el.detach();
                }
                this.setMetaFileModification(resourceId);
                return true;
            }
            log.error((Object)("The Element specified by path not found or a transaction isn't started yet. " + xpathStr));
        }
        catch (JaxenException e) {
            log.error((Object)("Error parsing xpath string " + resourceId + xpathStr), (Throwable)e);
        }
        return false;
    }

    protected void handleExceptionWithRollback(String resourceId, String msg, Throwable e) throws PersistenceException {
        log.error((Object)msg, e);
        this.rollbackTransaction(resourceId);
        throw new PersistenceException(msg, e);
    }

    protected void handleException(String msg, Throwable e) throws PersistenceException {
        log.error((Object)msg, e);
        throw new PersistenceException(msg, e);
    }

    protected void handleException(String msg) throws PersistenceException {
        log.error((Object)msg);
        throw new PersistenceException(msg);
    }

    public boolean isTransactionStarted(String resourceId) {
        return this.resourceMap.get(resourceId) != null && this.resourceMap.get(resourceId).isTransactionStarted();
    }

    public void init() {
        try {
            if (!this.metafilesDir.exists()) {
                FileUtils.forceMkdir((File)this.metafilesDir);
            }
        }
        catch (IOException e) {
            log.error((Object)("Error creating the resource meta files directory for " + this.metafilesDir.getAbsolutePath()), (Throwable)e);
        }
    }

    public boolean isUserModification(String name) {
        return this.userModifiedItems.remove(name);
    }

    public boolean setUserModification(String name) {
        return this.userModifiedItems.add(name);
    }

    protected boolean isMetaFileModification(String resourceId) {
        return this.modifyingMetaFiles.remove(resourceId);
    }

    public void setMetaFileModification(String resourceId) {
        this.modifyingMetaFiles.add(resourceId);
    }
}

