/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.ext.valves;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.registry.api.Registry;
import org.wso2.carbon.registry.api.RegistryService;
import org.wso2.carbon.registry.core.ghostregistry.GhostRegistry;
import org.wso2.carbon.tomcat.ext.internal.CarbonRealmServiceHolder;
import org.wso2.carbon.tomcat.ext.internal.Utils;
import org.wso2.carbon.tomcat.ext.utils.URLMappingHolder;
import org.wso2.carbon.user.api.TenantManager;
import org.wso2.carbon.user.core.service.RealmService;

public class CarbonContextCreatorValve
extends ValveBase {
    private static Log log = LogFactory.getLog(CarbonContextCreatorValve.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        try {
            this.initCarbonContext(request);
            this.getNext().invoke(request, response);
        }
        catch (Exception e) {
            log.error((Object)("Could not handle request: " + request.getRequestURI()), (Throwable)e);
        }
        finally {
            PrivilegedCarbonContext.destroyCurrentContext();
        }
    }

    public void initCarbonContext(Request request) throws Exception {
        String appName;
        String tenantDomain;
        String defaultHost;
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        String requestedHostName = request.getHost().getName();
        if (!requestedHostName.equalsIgnoreCase(defaultHost = URLMappingHolder.getInstance().getDefaultHost())) {
            tenantDomain = Utils.getTenantDomainFromURLMapping(request);
            appName = Utils.getAppNameForURLMapping(request);
        } else {
            tenantDomain = Utils.getTenantDomain((HttpServletRequest)request);
            appName = Utils.getAppNameFromRequest(request);
        }
        carbonContext.setTenantDomain(tenantDomain);
        carbonContext.setApplicationName(appName);
        if (tenantDomain != null) {
            RealmService userRealmService = CarbonRealmServiceHolder.getRealmService();
            TenantManager tenantManager = userRealmService.getTenantManager();
            int tenantId = tenantManager.getTenantId(tenantDomain);
            carbonContext.setTenantId(tenantId);
            org.wso2.carbon.registry.core.service.RegistryService registryService = CarbonRealmServiceHolder.getRegistryService();
            carbonContext.setRegistry(RegistryType.SYSTEM_CONFIGURATION, (Registry)new GhostRegistry((RegistryService)registryService, tenantId, RegistryType.SYSTEM_CONFIGURATION));
            carbonContext.setRegistry(RegistryType.SYSTEM_GOVERNANCE, (Registry)new GhostRegistry((RegistryService)registryService, tenantId, RegistryType.SYSTEM_GOVERNANCE));
        }
    }
}

