/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.request.QueryResponseWriter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.servlet.SolrRequestParsers;

public class DirectSolrConnection {
    final SolrCore core;
    final SolrRequestParsers parser;

    @Deprecated
    public DirectSolrConnection() {
        this(SolrCore.getSolrCore());
    }

    public DirectSolrConnection(SolrCore c) {
        this.core = c;
        this.parser = new SolrRequestParsers(c.getSolrConfig());
    }

    public DirectSolrConnection(String instanceDir, String dataDir, String loggingPath) {
        if (loggingPath != null) {
            File loggingConfig = new File(loggingPath);
            if (!loggingConfig.exists() && instanceDir != null) {
                loggingConfig = new File(new File(instanceDir), loggingPath);
            }
            if (loggingConfig.exists()) {
                System.setProperty("java.util.logging.config.file", loggingConfig.getAbsolutePath());
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "can not find logging file: " + loggingConfig);
            }
        }
        if (instanceDir == null) {
            instanceDir = SolrResourceLoader.locateInstanceDir();
        }
        try {
            CoreContainer cores = new CoreContainer(new SolrResourceLoader(instanceDir));
            SolrConfig solrConfig = new SolrConfig(instanceDir, "solrconfig.xml", null);
            CoreDescriptor dcore = new CoreDescriptor(cores, "", solrConfig.getResourceLoader().getInstanceDir());
            IndexSchema indexSchema = new IndexSchema(solrConfig, instanceDir + "/conf/schema.xml", null);
            this.core = new SolrCore(null, dataDir, solrConfig, indexSchema, dcore);
            cores.register("", this.core, false);
            this.parser = new SolrRequestParsers(solrConfig);
        }
        catch (Exception ee) {
            throw new RuntimeException(ee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String request(String pathAndParams, String body) throws Exception {
        String qt;
        String path = null;
        SolrParams params = null;
        int idx = pathAndParams.indexOf(63);
        if (idx > 0) {
            path = pathAndParams.substring(0, idx);
            params = SolrRequestParsers.parseQueryString(pathAndParams.substring(idx + 1));
        } else {
            path = pathAndParams;
            params = new MapSolrParams(new HashMap<String, String>());
        }
        SolrRequestHandler handler = this.core.getRequestHandler(path);
        if (handler == null && ("/select".equals(path) || "/select/".equalsIgnoreCase(path)) && (handler = this.core.getRequestHandler(qt = params.get("qt"))) == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unknown handler: " + qt);
        }
        if (handler == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unknown handler: " + path);
        }
        ArrayList<ContentStream> streams = new ArrayList<ContentStream>(1);
        if (body != null && body.length() > 0) {
            streams.add(new ContentStreamBase.StringStream(body));
        }
        SolrQueryRequest req = null;
        try {
            req = this.parser.buildRequestFrom(this.core, params, streams);
            SolrQueryResponse rsp = new SolrQueryResponse();
            this.core.execute(handler, req, rsp);
            if (rsp.getException() != null) {
                throw rsp.getException();
            }
            QueryResponseWriter responseWriter = this.core.getQueryResponseWriter(req);
            StringWriter out = new StringWriter();
            responseWriter.write(out, req, rsp);
            String string = out.toString();
            Object var14_13 = null;
            if (req != null) {
                req.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            block9: {
                Object var14_14 = null;
                if (req == null) break block9;
                req.close();
            }
            throw throwable;
        }
    }

    public void close() {
        this.core.close();
    }
}

