/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.SetBasedFieldSelector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardDoc;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.plugin.SolrCoreAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermVectorComponent
extends SearchComponent
implements SolrCoreAware {
    public static final String COMPONENT_NAME = "tv";
    protected NamedList initParams;
    public static final String TERM_VECTORS = "termVectors";

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        DocIterator iter;
        String[] fields;
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false)) {
            return;
        }
        NamedList<Object> termVectors = new NamedList<Object>();
        rb.rsp.add(TERM_VECTORS, termVectors);
        boolean termFreq = params.getBool("tv.tf", false);
        boolean positions = params.getBool("tv.positions", false);
        boolean offsets = params.getBool("tv.offsets", false);
        boolean docFreq = params.getBool("tv.df", false);
        boolean tfIdf = params.getBool("tv.tf_idf", false);
        boolean all = params.getBool("tv.all", false);
        if (all) {
            termFreq = true;
            positions = true;
            offsets = true;
            docFreq = true;
            tfIdf = true;
        }
        if ((fields = params.getParams("tv.fl")) == null) {
            fields = params.getParams("fl");
        }
        DocListAndSet listAndSet = rb.getResults();
        List<Integer> docIds = this.getInts(params.getParams("tv.docIds"));
        if (docIds != null && !docIds.isEmpty()) {
            iter = docIds.iterator();
        } else {
            DocList list = listAndSet.docList;
            iter = list.iterator();
        }
        SolrIndexSearcher searcher = rb.req.getSearcher();
        SolrIndexReader reader = searcher.getReader();
        TVMapper mapper = new TVMapper(fields, reader, termFreq, positions, offsets, docFreq, tfIdf);
        IndexSchema schema = rb.req.getSchema();
        String uniqFieldName = schema.getUniqueKeyField().getName();
        SetBasedFieldSelector fieldSelector = new SetBasedFieldSelector(Collections.singleton(uniqFieldName), Collections.emptySet());
        while (iter.hasNext()) {
            Integer docId = (Integer)iter.next();
            NamedList<String> docNL = new NamedList<String>();
            termVectors.add("doc-" + docId, docNL);
            mapper.docNL = docNL;
            Document document = ((IndexReader)reader).document(docId, fieldSelector);
            String uniqId = document.get(uniqFieldName);
            docNL.add("uniqueKey", uniqId);
            ((IndexReader)reader).getTermFreqVector((int)docId, mapper);
        }
        termVectors.add("uniqueKeyFieldName", uniqFieldName);
    }

    private List<Integer> getInts(String[] vals) {
        ArrayList<Integer> result = null;
        if (vals != null && vals.length > 0) {
            result = new ArrayList<Integer>(vals.length);
            for (int i = 0; i < vals.length; ++i) {
                try {
                    result.add(new Integer(vals[i]));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    @Override
    public int distributedProcess(ResponseBuilder rb) throws IOException {
        int result = ResponseBuilder.STAGE_DONE;
        if (rb.stage == ResponseBuilder.STAGE_GET_FIELDS) {
            HashMap<String, ArrayList<ShardDoc>> shardMap = new HashMap<String, ArrayList<ShardDoc>>();
            for (ShardDoc sdoc : rb.resultIds.values()) {
                ArrayList<ShardDoc> shardDocs = (ArrayList<ShardDoc>)shardMap.get(sdoc.shard);
                if (shardDocs == null) {
                    shardDocs = new ArrayList<ShardDoc>();
                    shardMap.put(sdoc.shard, shardDocs);
                }
                shardDocs.add(sdoc);
            }
            for (Collection shardDocs : shardMap.values()) {
                ShardRequest sreq = new ShardRequest();
                sreq.purpose = 64;
                sreq.shards = new String[]{((ShardDoc)shardDocs.iterator().next()).shard};
                sreq.params = new ModifiableSolrParams();
                sreq.params.add(rb.req.getParams());
                sreq.params.remove("q");
                ArrayList<String> ids = new ArrayList<String>(shardDocs.size());
                for (ShardDoc shardDoc : shardDocs) {
                    ids.add(shardDoc.id.toString());
                }
                sreq.params.add("tv.docIds", StrUtils.join(ids, ','));
                rb.addRequest(this, sreq);
            }
            result = ResponseBuilder.STAGE_DONE;
        }
        return result;
    }

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
    }

    @Override
    public void init(NamedList args) {
        super.init(args);
        this.initParams = args;
    }

    @Override
    public void inform(SolrCore core) {
    }

    @Override
    public String getVersion() {
        return "$Revision$";
    }

    @Override
    public String getSourceId() {
        return "$Id:$";
    }

    @Override
    public String getSource() {
        return "$Revision:$";
    }

    @Override
    public String getDescription() {
        return "A Component for working with Term Vectors";
    }

    private static class TVMapper
    extends TermVectorMapper {
        private NamedList docNL;
        private IndexReader reader;
        private Set<String> fields;
        private boolean termFreq;
        private boolean positions;
        private boolean offsets;
        private boolean docFreq;
        private boolean tfIdf;
        private boolean map;
        private boolean useOffsets;
        private boolean usePositions;
        private NamedList fieldNL;
        private Term currentTerm;

        public TVMapper(String[] fields, IndexReader reader, boolean termFreq, boolean positions, boolean offsets, boolean docFreq, boolean tfIdf) {
            this.reader = reader;
            this.fields = fields != null ? new HashSet<String>(Arrays.asList(fields)) : Collections.emptySet();
            this.termFreq = termFreq;
            this.positions = positions;
            this.offsets = offsets;
            this.docFreq = docFreq;
            this.tfIdf = tfIdf;
        }

        public void map(String term, int frequency, TermVectorOffsetInfo[] offsets, int[] positions) {
            if (this.map && this.fieldNL != null) {
                int i;
                NamedList<Serializable> termInfo = new NamedList<Serializable>();
                this.fieldNL.add(term, termInfo);
                if (this.termFreq) {
                    termInfo.add("tf", Integer.valueOf(frequency));
                }
                if (this.useOffsets) {
                    NamedList<Integer> theOffsets = new NamedList<Integer>();
                    termInfo.add("offsets", theOffsets);
                    for (i = 0; i < offsets.length; ++i) {
                        TermVectorOffsetInfo offset = offsets[i];
                        theOffsets.add("start", offset.getStartOffset());
                        theOffsets.add("end", offset.getEndOffset());
                    }
                }
                if (this.usePositions) {
                    NamedList<Integer> positionsNL = new NamedList<Integer>();
                    for (i = 0; i < positions.length; ++i) {
                        positionsNL.add("position", positions[i]);
                    }
                    termInfo.add("positions", positionsNL);
                }
                if (this.docFreq) {
                    termInfo.add("df", Integer.valueOf(this.getDocFreq(term)));
                }
                if (this.tfIdf) {
                    double tfIdfVal = (double)frequency / (double)this.getDocFreq(term);
                    termInfo.add("tf-idf", Double.valueOf(tfIdfVal));
                }
            }
        }

        private int getDocFreq(String term) {
            int result = 1;
            this.currentTerm = this.currentTerm.createTerm(term);
            try {
                TermEnum termEnum = this.reader.terms(this.currentTerm);
                if (termEnum != null && termEnum.term().equals(this.currentTerm)) {
                    result = termEnum.docFreq();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return result;
        }

        public void setExpectations(String field, int numTerms, boolean storeOffsets, boolean storePositions) {
            if (this.docFreq && this.reader != null) {
                this.currentTerm = new Term(field);
            }
            this.useOffsets = storeOffsets && this.offsets;
            boolean bl = this.usePositions = storePositions && this.positions;
            if (this.fields.isEmpty() || this.fields.contains(field)) {
                this.map = true;
                this.fieldNL = new NamedList();
                this.docNL.add(field, this.fieldNL);
            } else {
                this.map = false;
                this.fieldNL = null;
            }
        }

        public boolean isIgnoringPositions() {
            return !this.positions;
        }

        public boolean isIgnoringOffsets() {
            return !this.offsets;
        }
    }
}

