/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Arrays;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.ExecutorFactoryConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationChildBuilder;
import org.infinispan.configuration.global.GlobalJmxStatisticsConfigurationBuilder;
import org.infinispan.configuration.global.ScheduledExecutorFactoryConfigurationBuilder;
import org.infinispan.configuration.global.SerializationConfigurationBuilder;
import org.infinispan.configuration.global.ShutdownConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;

public class GlobalConfigurationBuilder
implements GlobalConfigurationChildBuilder {
    private ClassLoader cl = Thread.currentThread().getContextClassLoader();
    private final TransportConfigurationBuilder transport = new TransportConfigurationBuilder(this);
    private final GlobalJmxStatisticsConfigurationBuilder globalJmxStatistics = new GlobalJmxStatisticsConfigurationBuilder(this);
    private final SerializationConfigurationBuilder serialization = new SerializationConfigurationBuilder(this);
    private final ExecutorFactoryConfigurationBuilder asyncTransportExecutor;
    private final ExecutorFactoryConfigurationBuilder asyncListenerExecutor = new ExecutorFactoryConfigurationBuilder(this);
    private final ScheduledExecutorFactoryConfigurationBuilder evictionScheduledExecutor;
    private final ScheduledExecutorFactoryConfigurationBuilder replicationQueueScheduledExecutor;
    private final ShutdownConfigurationBuilder shutdown;

    public GlobalConfigurationBuilder() {
        this.asyncTransportExecutor = new ExecutorFactoryConfigurationBuilder(this);
        this.evictionScheduledExecutor = new ScheduledExecutorFactoryConfigurationBuilder(this);
        this.replicationQueueScheduledExecutor = new ScheduledExecutorFactoryConfigurationBuilder(this);
        this.shutdown = new ShutdownConfigurationBuilder(this);
    }

    public GlobalConfigurationBuilder clusteredDefault() {
        this.transport().defaultTransport().clearProperties().asyncTransportExecutor().addProperty("threadNamePrefix", "asyncTransportThread");
        return this;
    }

    public GlobalConfigurationBuilder nonClusteredDefault() {
        this.transport().transport(null).clearProperties();
        return this;
    }

    protected ClassLoader getClassLoader() {
        return this.cl;
    }

    public GlobalConfigurationBuilder classLoader(ClassLoader cl) {
        this.cl = cl;
        return this;
    }

    @Override
    public TransportConfigurationBuilder transport() {
        return this.transport;
    }

    @Override
    public GlobalJmxStatisticsConfigurationBuilder globalJmxStatistics() {
        return this.globalJmxStatistics;
    }

    @Override
    public SerializationConfigurationBuilder serialization() {
        return this.serialization;
    }

    @Override
    public ExecutorFactoryConfigurationBuilder asyncTransportExecutor() {
        return this.asyncTransportExecutor;
    }

    @Override
    public ExecutorFactoryConfigurationBuilder asyncListenerExecutor() {
        return this.asyncListenerExecutor;
    }

    @Override
    public ScheduledExecutorFactoryConfigurationBuilder evictionScheduledExecutor() {
        return this.evictionScheduledExecutor;
    }

    @Override
    public ScheduledExecutorFactoryConfigurationBuilder replicationQueueScheduledExecutor() {
        return this.replicationQueueScheduledExecutor;
    }

    @Override
    public ShutdownConfigurationBuilder shutdown() {
        return this.shutdown;
    }

    public void validate() {
        for (AbstractGlobalConfigurationBuilder validatable : Arrays.asList(this.asyncListenerExecutor, this.asyncTransportExecutor, this.evictionScheduledExecutor, this.replicationQueueScheduledExecutor, this.globalJmxStatistics, this.transport, this.serialization, this.shutdown)) {
            validatable.validate();
        }
    }

    @Override
    public GlobalConfiguration build() {
        this.validate();
        return new GlobalConfiguration(this.asyncListenerExecutor.create(), this.asyncTransportExecutor.create(), this.evictionScheduledExecutor.create(), this.replicationQueueScheduledExecutor.create(), this.globalJmxStatistics.create(), this.transport.create(), this.serialization.create(), this.shutdown.create(), this.cl);
    }

    public GlobalConfigurationBuilder read(GlobalConfiguration template) {
        this.cl = template.classLoader();
        this.asyncListenerExecutor.read(template.asyncListenerExecutor());
        this.asyncTransportExecutor.read(template.asyncTransportExecutor());
        this.evictionScheduledExecutor.read(template.evictionScheduledExecutor());
        this.globalJmxStatistics.read(template.globalJmxStatistics());
        this.replicationQueueScheduledExecutor.read(template.replicationQueueScheduledExecutor());
        this.serialization.read(template.serialization());
        this.shutdown.read(template.shutdown());
        this.transport.read(template.transport());
        return this;
    }

    public static GlobalConfigurationBuilder defaultClusteredBuilder() {
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
        builder.transport().transport(new JGroupsTransport()).asyncTransportExecutor().addProperty("threadNamePrefix", "asyncTransportThread");
        return builder;
    }

    public String toString() {
        return "GlobalConfigurationBuilder{asyncListenerExecutor=" + this.asyncListenerExecutor + ", cl=" + this.cl + ", transport=" + this.transport + ", globalJmxStatistics=" + this.globalJmxStatistics + ", serialization=" + this.serialization + ", asyncTransportExecutor=" + this.asyncTransportExecutor + ", evictionScheduledExecutor=" + this.evictionScheduledExecutor + ", replicationQueueScheduledExecutor=" + this.replicationQueueScheduledExecutor + ", shutdown=" + this.shutdown + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalConfigurationBuilder that = (GlobalConfigurationBuilder)o;
        if (this.asyncListenerExecutor != null ? !this.asyncListenerExecutor.equals(that.asyncListenerExecutor) : that.asyncListenerExecutor != null) {
            return false;
        }
        if (this.asyncTransportExecutor != null ? !this.asyncTransportExecutor.equals(that.asyncTransportExecutor) : that.asyncTransportExecutor != null) {
            return false;
        }
        if (this.cl != null ? !this.cl.equals(that.cl) : that.cl != null) {
            return false;
        }
        if (this.evictionScheduledExecutor != null ? !this.evictionScheduledExecutor.equals(that.evictionScheduledExecutor) : that.evictionScheduledExecutor != null) {
            return false;
        }
        if (this.globalJmxStatistics != null ? !this.globalJmxStatistics.equals(that.globalJmxStatistics) : that.globalJmxStatistics != null) {
            return false;
        }
        if (this.replicationQueueScheduledExecutor != null ? !this.replicationQueueScheduledExecutor.equals(that.replicationQueueScheduledExecutor) : that.replicationQueueScheduledExecutor != null) {
            return false;
        }
        if (this.serialization != null ? !this.serialization.equals(that.serialization) : that.serialization != null) {
            return false;
        }
        if (this.shutdown != null ? !this.shutdown.equals(that.shutdown) : that.shutdown != null) {
            return false;
        }
        return !(this.transport != null ? !this.transport.equals(that.transport) : that.transport != null);
    }

    public int hashCode() {
        int result = this.cl != null ? this.cl.hashCode() : 0;
        result = 31 * result + (this.transport != null ? this.transport.hashCode() : 0);
        result = 31 * result + (this.globalJmxStatistics != null ? this.globalJmxStatistics.hashCode() : 0);
        result = 31 * result + (this.serialization != null ? this.serialization.hashCode() : 0);
        result = 31 * result + (this.asyncTransportExecutor != null ? this.asyncTransportExecutor.hashCode() : 0);
        result = 31 * result + (this.asyncListenerExecutor != null ? this.asyncListenerExecutor.hashCode() : 0);
        result = 31 * result + (this.evictionScheduledExecutor != null ? this.evictionScheduledExecutor.hashCode() : 0);
        result = 31 * result + (this.replicationQueueScheduledExecutor != null ? this.replicationQueueScheduledExecutor.hashCode() : 0);
        result = 31 * result + (this.shutdown != null ? this.shutdown.hashCode() : 0);
        return result;
    }
}

