/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.net.Socket;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.Processor;
import org.apache.coyote.http11.AbstractHttp11JsseProtocol;
import org.apache.coyote.http11.Http11Processor;
import org.apache.coyote.http11.upgrade.UpgradeBioProcessor;
import org.apache.coyote.http11.upgrade.UpgradeInbound;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.JIoEndpoint;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SocketWrapper;

public class Http11Protocol
extends AbstractHttp11JsseProtocol {
    private static final Log log = LogFactory.getLog(Http11Protocol.class);
    protected Http11ConnectionHandler cHandler;
    private int disableKeepAlivePercentage = 75;

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected AbstractEndpoint.Handler getHandler() {
        return this.cHandler;
    }

    public Http11Protocol() {
        this.endpoint = new JIoEndpoint();
        this.cHandler = new Http11ConnectionHandler(this);
        ((JIoEndpoint)this.endpoint).setHandler((JIoEndpoint.Handler)this.cHandler);
        this.setSoLinger(-1);
        this.setSoTimeout(60000);
        this.setTcpNoDelay(true);
    }

    public int getDisableKeepAlivePercentage() {
        return this.disableKeepAlivePercentage;
    }

    public void setDisableKeepAlivePercentage(int disableKeepAlivePercentage) {
        this.disableKeepAlivePercentage = disableKeepAlivePercentage < 0 ? 0 : (disableKeepAlivePercentage > 100 ? 100 : disableKeepAlivePercentage);
    }

    @Override
    protected String getNamePrefix() {
        return "http-bio";
    }

    protected static class Http11ConnectionHandler
    extends AbstractProtocol.AbstractConnectionHandler<Socket, Http11Processor>
    implements JIoEndpoint.Handler {
        protected Http11Protocol proto;

        Http11ConnectionHandler(Http11Protocol proto) {
            this.proto = proto;
        }

        @Override
        protected AbstractProtocol getProtocol() {
            return this.proto;
        }

        @Override
        protected Log getLog() {
            return log;
        }

        public SSLImplementation getSslImplementation() {
            return this.proto.sslImplementation;
        }

        @Override
        public void release(SocketWrapper<Socket> socket, Processor<Socket> processor, boolean isSocketClosing, boolean addToPoller) {
            processor.recycle(isSocketClosing);
            this.recycledProcessors.offer(processor);
        }

        @Override
        protected void initSsl(SocketWrapper<Socket> socket, Processor<Socket> processor) {
            if (this.proto.isSSLEnabled() && this.proto.sslImplementation != null) {
                processor.setSslSupport(this.proto.sslImplementation.getSSLSupport((Socket)socket.getSocket()));
            } else {
                processor.setSslSupport(null);
            }
        }

        @Override
        protected void longPoll(SocketWrapper<Socket> socket, Processor<Socket> processor) {
            this.connections.put(socket.getSocket(), processor);
        }

        @Override
        protected Http11Processor createProcessor() {
            Http11Processor processor = new Http11Processor(this.proto.getMaxHttpHeaderSize(), (JIoEndpoint)this.proto.endpoint, this.proto.getMaxTrailerSize());
            processor.setAdapter(this.proto.adapter);
            processor.setMaxKeepAliveRequests(this.proto.getMaxKeepAliveRequests());
            processor.setKeepAliveTimeout(this.proto.getKeepAliveTimeout());
            processor.setConnectionUploadTimeout(this.proto.getConnectionUploadTimeout());
            processor.setDisableUploadTimeout(this.proto.getDisableUploadTimeout());
            processor.setCompressionMinSize(this.proto.getCompressionMinSize());
            processor.setCompression(this.proto.getCompression());
            processor.setNoCompressionUserAgents(this.proto.getNoCompressionUserAgents());
            processor.setCompressableMimeTypes(this.proto.getCompressableMimeTypes());
            processor.setRestrictedUserAgents(this.proto.getRestrictedUserAgents());
            processor.setSocketBuffer(this.proto.getSocketBuffer());
            processor.setMaxSavePostSize(this.proto.getMaxSavePostSize());
            processor.setServer(this.proto.getServer());
            processor.setDisableKeepAlivePercentage(this.proto.getDisableKeepAlivePercentage());
            this.register(processor);
            return processor;
        }

        @Override
        protected Processor<Socket> createUpgradeProcessor(SocketWrapper<Socket> socket, UpgradeInbound inbound) throws IOException {
            return new UpgradeBioProcessor(socket, inbound);
        }
    }
}

