/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.h2.osgi.console;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.h2.constant.SysProperties;
import org.h2.server.ShutdownHandler;
import org.h2.tools.Console;
import org.h2.tools.Server;
import org.h2.util.Tool;

public class ConsoleService
extends Tool
implements ShutdownHandler {
    private static final Log log = LogFactory.getLog(ConsoleService.class);
    private Server web;
    private Server tcp;
    private Server pg;
    private boolean isWindows;

    public static void main(String[] args) throws SQLException {
        new Console().runTool(args);
    }

    public void runTool(String[] args) throws SQLException {
        SQLException startException;
        boolean browserStart;
        block17: {
            boolean pgStart;
            block16: {
                this.isWindows = SysProperties.getStringSetting("os.name", "").startsWith("Windows");
                boolean tcpStart = false;
                pgStart = false;
                boolean webStart = false;
                browserStart = false;
                for (int i = 0; args != null && i < args.length; ++i) {
                    String arg = args[i];
                    if (arg == null) continue;
                    if ("-?".equals(arg) || "-help".equals(arg)) {
                        this.showUsage();
                        return;
                    }
                    if ("-web".equals(arg)) {
                        webStart = true;
                        continue;
                    }
                    if ("-browser".equals(arg)) {
                        webStart = true;
                        browserStart = true;
                        continue;
                    }
                    if ("-tcp".equals(arg)) {
                        tcpStart = true;
                        continue;
                    }
                    if (!"-pg".equals(arg)) continue;
                    pgStart = true;
                }
                startException = null;
                boolean webRunning = false;
                if (webStart) {
                    try {
                        this.web = Server.createWebServer(args);
                        this.web.setShutdownHandler(this);
                        this.web.start();
                        log.info((Object)"Starting H2 Web server...");
                        webRunning = true;
                    }
                    catch (SQLException e) {
                        this.printProblem(e, this.web);
                        startException = e;
                    }
                }
                if (tcpStart) {
                    try {
                        this.tcp = Server.createTcpServer(args);
                        this.tcp.start();
                        log.info((Object)"Starting H2 TCP server...");
                    }
                    catch (SQLException e) {
                        this.printProblem(e, this.tcp);
                        if (startException != null) break block16;
                        startException = e;
                    }
                }
            }
            if (pgStart) {
                try {
                    this.pg = Server.createPgServer(args);
                    this.pg.start();
                    log.info((Object)"Starting H2 PG server...");
                }
                catch (SQLException e) {
                    this.printProblem(e, this.pg);
                    if (startException != null) break block17;
                    startException = e;
                }
            }
        }
        if (browserStart) {
            Server.openBrowser(this.web.getURL());
        }
        if (startException != null) {
            throw startException;
        }
    }

    private void printProblem(SQLException e, Server server) {
        log.error((Object)"H2 Error", (Throwable)e);
        if (server == null) {
            e.printStackTrace();
        } else {
            this.out.println(server.getStatus());
            this.out.println("Root cause: " + e.getMessage());
        }
    }

    public void shutdown() {
        this.stopAll();
    }

    void stopAll() {
        if (this.web != null && this.web.isRunning(false)) {
            this.web.stop();
            this.web = null;
            log.info((Object)"Stopping H2 Web server...");
        }
        if (this.tcp != null && this.tcp.isRunning(false)) {
            this.tcp.stop();
            this.tcp = null;
            log.info((Object)"Stopping H2 TCP server...");
        }
        if (this.pg != null && this.pg.isRunning(false)) {
            this.pg.stop();
            this.pg = null;
            log.info((Object)"Stopping H2 PG server...");
        }
    }

    public boolean isServerRunning() {
        return this.web != null && this.web.isRunning(false) || this.tcp != null && this.tcp.isRunning(false) || this.pg != null && this.pg.isRunning(false);
    }
}

