/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jaqu;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.h2.jaqu.CompareType;
import org.h2.jaqu.Condition;
import org.h2.jaqu.ConditionAndOr;
import org.h2.jaqu.Db;
import org.h2.jaqu.Query;
import org.h2.jaqu.SQLStatement;
import org.h2.jaqu.SelectColumn;
import org.h2.jaqu.SelectTable;
import org.h2.jaqu.util.Utils;
import org.h2.util.StatementBuilder;

class TableDefinition<T> {
    String tableName;
    private Class<T> clazz;
    private ArrayList<FieldDefinition> fields = Utils.newArrayList();
    private IdentityHashMap<Object, FieldDefinition> fieldMap = Utils.newIdentityHashMap();
    private List<String> primaryKeyColumnNames;
    private ArrayList<IndexDefinition> indexes = Utils.newArrayList();

    TableDefinition(Class<T> clazz) {
        this.clazz = clazz;
        this.tableName = clazz.getSimpleName();
    }

    List<FieldDefinition> getFields() {
        return this.fields;
    }

    void setTableName(String string) {
        this.tableName = string;
    }

    void setPrimaryKey(Object[] objectArray) {
        this.primaryKeyColumnNames = this.mapColumnNames(objectArray);
        for (FieldDefinition fieldDefinition : this.fieldMap.values()) {
            fieldDefinition.isPrimaryKey = this.primaryKeyColumnNames.contains(fieldDefinition.columnName);
        }
    }

    <A> String getColumnName(A a) {
        FieldDefinition fieldDefinition = this.fieldMap.get(a);
        return fieldDefinition == null ? null : fieldDefinition.columnName;
    }

    private List<String> mapColumnNames(Object[] objectArray) {
        ArrayList<String> arrayList = Utils.newArrayList();
        for (Object object : objectArray) {
            arrayList.add(this.getColumnName(object));
        }
        return arrayList;
    }

    void addIndex(Object[] objectArray) {
        IndexDefinition indexDefinition = new IndexDefinition();
        indexDefinition.indexName = this.tableName + "_" + this.indexes.size();
        indexDefinition.columnNames = this.mapColumnNames(objectArray);
        this.indexes.add(indexDefinition);
    }

    public void setMaxLength(Object object, int n) {
        String string = this.getColumnName(object);
        for (FieldDefinition fieldDefinition : this.fields) {
            if (!fieldDefinition.columnName.equals(string)) continue;
            fieldDefinition.maxLength = n;
            break;
        }
    }

    void mapFields() {
        Field[] fieldArray;
        for (Field field : fieldArray = this.clazz.getFields()) {
            FieldDefinition fieldDefinition = new FieldDefinition();
            fieldDefinition.field = field;
            fieldDefinition.columnName = field.getName();
            fieldDefinition.dataType = this.getDataType(field);
            this.fields.add(fieldDefinition);
        }
    }

    private String getDataType(Field field) {
        Class<?> clazz = field.getType();
        if (clazz == Integer.class) {
            return "INT";
        }
        if (clazz == String.class) {
            return "VARCHAR";
        }
        if (clazz == Double.class) {
            return "DOUBLE";
        }
        if (clazz == BigDecimal.class) {
            return "DECIMAL";
        }
        if (clazz == java.util.Date.class) {
            return "DATE";
        }
        if (clazz == Date.class) {
            return "DATE";
        }
        if (clazz == Time.class) {
            return "TIME";
        }
        if (clazz == Timestamp.class) {
            return "TIMESTAMP";
        }
        return "VARCHAR";
    }

    void insert(Db db, Object object) {
        SQLStatement sQLStatement = new SQLStatement(db);
        StatementBuilder statementBuilder = new StatementBuilder("INSERT INTO ");
        statementBuilder.append(this.tableName).append('(');
        for (FieldDefinition fieldDefinition : this.fields) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(fieldDefinition.columnName);
        }
        statementBuilder.append(") VALUES(");
        statementBuilder.resetCount();
        for (FieldDefinition fieldDefinition : this.fields) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append('?');
            Object object2 = fieldDefinition.getValue(object);
            sQLStatement.addParameter(object2);
        }
        statementBuilder.append(')');
        sQLStatement.setSQL(statementBuilder.toString());
        sQLStatement.executeUpdate();
    }

    void merge(Db db, Object object) {
        if (this.primaryKeyColumnNames == null || this.primaryKeyColumnNames.size() == 0) {
            throw new IllegalStateException("No primary key columns defined for table " + object.getClass() + " - no update possible");
        }
        SQLStatement sQLStatement = new SQLStatement(db);
        StatementBuilder statementBuilder = new StatementBuilder("MERGE INTO ");
        statementBuilder.append(this.tableName).append(" (");
        statementBuilder.resetCount();
        for (FieldDefinition fieldDefinition : this.fields) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(fieldDefinition.columnName);
        }
        statementBuilder.append(") KEY(");
        statementBuilder.resetCount();
        for (FieldDefinition fieldDefinition : this.fields) {
            if (!fieldDefinition.isPrimaryKey) continue;
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(fieldDefinition.columnName);
        }
        statementBuilder.append(") ");
        statementBuilder.resetCount();
        statementBuilder.append("VALUES (");
        for (FieldDefinition fieldDefinition : this.fields) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append('?');
            Object object2 = fieldDefinition.getValue(object);
            sQLStatement.addParameter(object2);
        }
        statementBuilder.append(')');
        sQLStatement.setSQL(statementBuilder.toString());
        sQLStatement.executeUpdate();
    }

    void update(Db db, Object object) {
        if (this.primaryKeyColumnNames == null || this.primaryKeyColumnNames.size() == 0) {
            throw new IllegalStateException("No primary key columns defined for table " + object.getClass() + " - no update possible");
        }
        SQLStatement sQLStatement = new SQLStatement(db);
        StatementBuilder statementBuilder = new StatementBuilder("UPDATE ");
        statementBuilder.append(this.tableName).append(" SET ");
        statementBuilder.resetCount();
        for (FieldDefinition object22 : this.fields) {
            if (object22.isPrimaryKey) continue;
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(object22.columnName);
            statementBuilder.append(" = ?");
            Object bl = object22.getValue(object);
            sQLStatement.addParameter(bl);
        }
        Iterator<FieldDefinition> iterator = Utils.newObject(object.getClass());
        Query<Iterator<FieldDefinition>> query = Query.from(db, iterator);
        boolean bl = true;
        for (FieldDefinition fieldDefinition : this.fields) {
            if (!fieldDefinition.isPrimaryKey) continue;
            Object object2 = fieldDefinition.getValue(iterator);
            Object object3 = fieldDefinition.getValue(object);
            if (!bl) {
                query.addConditionToken(ConditionAndOr.AND);
            }
            bl = false;
            query.addConditionToken(new Condition<Object>(object2, object3, CompareType.EQUAL));
        }
        sQLStatement.setSQL(statementBuilder.toString());
        query.appendWhere(sQLStatement);
        sQLStatement.executeUpdate();
    }

    TableDefinition<T> createTableIfRequired(Db db) {
        SQLStatement sQLStatement = new SQLStatement(db);
        StatementBuilder statementBuilder = new StatementBuilder("CREATE TABLE IF NOT EXISTS ");
        statementBuilder.append(this.tableName).append('(');
        for (FieldDefinition object : this.fields) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(object.columnName).append(' ').append(object.dataType);
            if (object.maxLength == 0) continue;
            statementBuilder.append('(').append(object.maxLength).append(')');
        }
        if (this.primaryKeyColumnNames != null) {
            statementBuilder.append(", PRIMARY KEY(");
            statementBuilder.resetCount();
            for (String string : this.primaryKeyColumnNames) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(string);
            }
            statementBuilder.append(')');
        }
        statementBuilder.append(')');
        sQLStatement.setSQL(statementBuilder.toString());
        sQLStatement.executeUpdate();
        return this;
    }

    void mapObject(Object object) {
        this.fieldMap.clear();
        this.initObject(object, this.fieldMap);
    }

    void initObject(Object object, Map<Object, FieldDefinition> map) {
        for (FieldDefinition fieldDefinition : this.fields) {
            fieldDefinition.initWithNewObject(object);
            map.put(fieldDefinition.getValue(object), fieldDefinition);
        }
    }

    void initSelectObject(SelectTable<T> selectTable, Object object, Map<Object, SelectColumn<T>> map) {
        for (FieldDefinition fieldDefinition : this.fields) {
            fieldDefinition.initWithNewObject(object);
            SelectColumn<T> selectColumn = new SelectColumn<T>(selectTable, fieldDefinition);
            map.put(fieldDefinition.getValue(object), selectColumn);
        }
    }

    void readRow(Object object, ResultSet resultSet) {
        for (int i = 0; i < this.fields.size(); ++i) {
            FieldDefinition fieldDefinition = this.fields.get(i);
            Object object2 = fieldDefinition.read(resultSet, i + 1);
            fieldDefinition.setValue(object, object2);
        }
    }

    SQLStatement getSelectList(Db db) {
        SQLStatement sQLStatement = new SQLStatement(db);
        for (int i = 0; i < this.fields.size(); ++i) {
            if (i > 0) {
                sQLStatement.appendSQL(", ");
            }
            FieldDefinition fieldDefinition = this.fields.get(i);
            sQLStatement.appendSQL(fieldDefinition.columnName);
        }
        return sQLStatement;
    }

    <Y, X> SQLStatement getSelectList(Query<Y> query, X x) {
        SQLStatement sQLStatement = new SQLStatement(query.getDb());
        for (int i = 0; i < this.fields.size(); ++i) {
            if (i > 0) {
                sQLStatement.appendSQL(", ");
            }
            FieldDefinition fieldDefinition = this.fields.get(i);
            Object object = fieldDefinition.getValue(x);
            query.appendSQL(sQLStatement, object);
        }
        return sQLStatement;
    }

    <Y, X> void copyAttributeValues(Query<Y> query, X x, X x2) {
        for (FieldDefinition fieldDefinition : this.fields) {
            Object object = fieldDefinition.getValue(x2);
            SelectColumn<Y> selectColumn = query.getSelectColumn(object);
            Object object2 = selectColumn.getCurrentValue();
            fieldDefinition.setValue(x, object2);
        }
    }

    static class FieldDefinition {
        String columnName;
        Field field;
        String dataType;
        int maxLength;
        boolean isPrimaryKey;

        FieldDefinition() {
        }

        Object getValue(Object object) {
            try {
                return this.field.get(object);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        void initWithNewObject(Object object) {
            Object obj = Utils.newObject(this.field.getType());
            this.setValue(object, obj);
        }

        void setValue(Object object, Object object2) {
            try {
                object2 = Utils.convert(object2, this.field.getType());
                this.field.set(object, object2);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        Object read(ResultSet resultSet, int n) {
            try {
                return resultSet.getObject(n);
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException);
            }
        }
    }

    static class IndexDefinition {
        boolean unique;
        String indexName;
        List<String> columnNames;

        IndexDefinition() {
        }
    }
}

