/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.ListenerManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.core.ServerStatus;
import org.wso2.carbon.core.init.JMXServerManager;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.core.internal.CarbonCoreServiceComponent;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.core.util.ClusteringUtil;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.utils.ServerException;

public class StartupFinalizerServiceComponent
implements ServiceListener {
    private static final Log log = LogFactory.getLog(StartupFinalizerServiceComponent.class);
    private static final String TRANSPORT_MANAGER = "org.wso2.carbon.tomcat.ext.transport.ServletTransportManager";
    private ConfigurationContext configCtx;
    private List<String> requiredServices = new ArrayList<String>();
    private BundleContext bundleContext;
    private Timer pendingServicesObservationTimer = new Timer();
    private CarbonCoreDataHolder dataHolder = CarbonCoreDataHolder.getInstance();
    private ServiceRegistration listerManagerServiceRegistration;

    protected void activate(ComponentContext ctxt) {
        try {
            this.bundleContext = ctxt.getBundleContext();
            this.populateRequiredServices();
            if (this.requiredServices.isEmpty()) {
                this.completeInitialization(this.bundleContext);
                return;
            }
            StringBuffer ldapFilter = new StringBuffer("(|");
            for (String service : this.requiredServices) {
                ldapFilter.append("(").append("objectClass").append("=").append(service).append(")");
            }
            ldapFilter.append(")");
            this.bundleContext.addServiceListener((ServiceListener)this, ldapFilter.toString());
            ServiceReference[] serviceReferences = this.bundleContext.getServiceReferences((String)null, ldapFilter.toString());
            if (serviceReferences != null) {
                for (ServiceReference reference : serviceReferences) {
                    String service = ((String[])reference.getProperty("objectClass"))[0];
                    this.requiredServices.remove(service);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Removed pending service " + service));
                }
            }
            if (this.requiredServices.isEmpty()) {
                this.completeInitialization(this.bundleContext);
            } else {
                this.schedulePendingServicesObservationTimer();
            }
        }
        catch (Throwable e) {
            log.fatal((Object)"Cannot activate StartupFinalizerServiceComponent", e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        this.listerManagerServiceRegistration.unregister();
    }

    private void populateRequiredServices() {
        Bundle[] bundles;
        for (Bundle bundle : bundles = this.bundleContext.getBundles()) {
            String[] values;
            String requiredServiceList = (String)bundle.getHeaders().get("ListenerManager-RequiredServices");
            if (requiredServiceList == null) continue;
            for (String value : values = requiredServiceList.split(",")) {
                this.requiredServices.add(value);
            }
        }
    }

    private void schedulePendingServicesObservationTimer() {
        this.pendingServicesObservationTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (!StartupFinalizerServiceComponent.this.requiredServices.isEmpty()) {
                    StringBuffer services = new StringBuffer();
                    for (String service : StartupFinalizerServiceComponent.this.requiredServices) {
                        services.append(service).append(",");
                    }
                    log.warn((Object)("Waiting for required OSGi services: " + services.toString()));
                }
            }
        }, 60000L, 60000L);
    }

    private void completeInitialization(BundleContext bundleContext) {
        bundleContext.removeServiceListener((ServiceListener)this);
        this.pendingServicesObservationTimer.cancel();
        ListenerManager listenerManager = this.configCtx.getListenerManager();
        if (listenerManager == null) {
            listenerManager = new ListenerManager();
        }
        listenerManager.setShutdownHookRequired(false);
        listenerManager.startSystem(this.configCtx);
        try {
            TenantAxisUtils.initializeTenantTransports(this.configCtx);
        }
        catch (AxisFault e) {
            log.error((Object)"Cannot initialize tenant transports", (Throwable)e);
        }
        try {
            ClusteringUtil.enableClustering(this.configCtx);
        }
        catch (AxisFault e) {
            String msg = "Cannot initialize cluster";
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        if (CarbonUtils.isRunningInStandaloneMode()) {
            try {
                Class<?> transportManagerClass = Class.forName(TRANSPORT_MANAGER);
                Object transportManager = transportManagerClass.newInstance();
                Method method = transportManagerClass.getMethod("startTransports", new Class[0]);
                method.invoke(transportManager, new Object[0]);
            }
            catch (Exception e) {
                String msg = "Cannot start transports";
                log.fatal((Object)msg, (Throwable)e);
                return;
            }
        }
        this.listerManagerServiceRegistration = bundleContext.registerService(ListenerManager.class.getName(), (Object)listenerManager, null);
        try {
            new JMXServerManager().startJMXService();
        }
        catch (ServerException e) {
            log.error((Object)"Cannot start JMX service", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Started Transport Listener Manager");
        }
        CarbonCoreServiceComponent.startup();
        this.setServerStartTimeParam();
        this.printInfo();
    }

    private void setServerStartTimeParam() {
        Parameter startTimeParam = new Parameter();
        startTimeParam.setName("wso2carbon.server.start.time");
        startTimeParam.setValue((Object)System.getProperty("wso2carbon.start.time"));
        try {
            this.configCtx.getAxisConfiguration().addParameter(startTimeParam);
        }
        catch (AxisFault e) {
            log.error((Object)"Could not set the  server start time parameter", (Throwable)e);
        }
    }

    private void printInfo() {
        long startTime = Long.parseLong(System.getProperty("wso2carbon.start.time"));
        long startupTime = (System.currentTimeMillis() - startTime) / 1000L;
        try {
            log.info((Object)("Server           :  " + this.dataHolder.getServerConfigurationService().getFirstProperty("Name") + "-" + this.dataHolder.getServerConfigurationService().getFirstProperty("Version")));
        }
        catch (Exception e) {
            log.debug((Object)"Error while retrieving server configuration", (Throwable)e);
        }
        try {
            ServerStatus.setServerRunning();
        }
        catch (AxisFault e) {
            String msg = "Cannot set server to running mode";
            log.error((Object)msg, (Throwable)e);
        }
        log.info((Object)("WSO2 Carbon started in " + startupTime + " sec"));
        System.getProperties().remove("setup");
    }

    protected void setConfigurationContext(ConfigurationContextService configCtx) {
        this.configCtx = configCtx.getServerConfigContext();
    }

    protected void unsetConfigurationContext(ConfigurationContextService configCtx) {
        this.configCtx = null;
    }

    protected void setRealmService(RealmService realmService) {
    }

    protected void unsetRealmService(RealmService realmService) {
    }

    protected void setRegistryService(RegistryService registryService) {
    }

    protected void unsetRegistryService(RegistryService registryService) {
    }

    public synchronized void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1) {
            String service = ((String[])event.getServiceReference().getProperty("objectClass"))[0];
            this.requiredServices.remove(service);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removed pending service " + service));
            }
            if (this.requiredServices.isEmpty()) {
                this.completeInitialization(this.bundleContext);
            }
        }
    }
}

