/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.common.utils;

import javax.servlet.http.HttpServletRequest;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class RegistryUtil {
    private static final Log log = LogFactory.getLog(RegistryUtil.class);

    public static String getPath(HttpServletRequest request) {
        String path = request.getParameter("path");
        if (path == null || "".equals(path)) {
            path = (String)request.getAttribute("path");
        }
        return path;
    }

    public static String getSessionResourcePath() throws RegistryException {
        MessageContext messageContext = MessageContext.getCurrentMessageContext();
        if (messageContext == null) {
            String msg = "Could not get the user's Registry session. Message context not found.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        HttpServletRequest request = (HttpServletRequest)messageContext.getProperty("transport.http.servletRequest");
        String resourcePath = (String)request.getSession().getAttribute("session.resource.path");
        return resourcePath;
    }

    public static void setSessionResourcePath(String path) throws RegistryException {
        MessageContext messageContext = MessageContext.getCurrentMessageContext();
        if (messageContext == null) {
            String msg = "Could not get the user's Registry session. Message context not found.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        HttpServletRequest request = (HttpServletRequest)messageContext.getProperty("transport.http.servletRequest");
        request.getSession().setAttribute("session.resource.path", (Object)path);
    }

    public static String getResourcePath() throws RegistryException {
        MessageContext messageContext = MessageContext.getCurrentMessageContext();
        if (messageContext == null) {
            String msg = "Could not get the user's Registry session. Message context not found.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        HttpServletRequest request = (HttpServletRequest)messageContext.getProperty("transport.http.servletRequest");
        String resourcePath = (String)request.getSession().getAttribute("session.resource.path");
        if (resourcePath == null) {
            resourcePath = "/";
        }
        return resourcePath;
    }

    public static String generateOptionsFor(String value, String[] options) {
        StringBuffer ret = new StringBuffer();
        for (String option : options) {
            ret.append("<option value=\"");
            ret.append(option);
            ret.append("\"");
            if (option.equalsIgnoreCase(value)) {
                ret.append(" selected");
            }
            ret.append(">");
            ret.append(option);
            ret.append("</option>\n");
        }
        return ret.toString();
    }

    public static String getResourcePathFromVersionPath(String path) {
        return path.substring(0, path.indexOf(";version:"));
    }
}

