/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bridge;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.wso2.carbon.bridge.CarbonHttpSession;

public class HttpSessionManager
implements HttpSessionListener {
    private static Map<String, CarbonHttpSession> sessions = new ConcurrentHashMap<String, CarbonHttpSession>();

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        HttpSession session = httpSessionEvent.getSession();
        sessions.put(session.getId(), new CarbonHttpSession(session));
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        HttpSession session = httpSessionEvent.getSession();
        sessions.remove(session.getId());
    }

    public static CarbonHttpSession getSession(String sessionId) {
        return sessions.get(sessionId);
    }

    public static void invalidateSessions() {
        for (CarbonHttpSession session : sessions.values()) {
            try {
                session.invalidate();
            }
            catch (Throwable throwable) {}
        }
        sessions.clear();
    }
}

