/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.services.authentication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;

public class RememberMeDAO {
    private static final Log log = LogFactory.getLog(RememberMeDAO.class);
    private Registry registry;

    public RememberMeDAO(Registry registry) {
        this.registry = registry;
    }

    public void updateToken(String userName, String value) throws Exception {
        block8: {
            Collection userResource = null;
            boolean transactionStarted = Transaction.isStarted();
            try {
                if (!this.registry.resourceExists("/users/" + userName)) {
                    userResource = this.registry.newCollection();
                    this.registry.put("/users/" + userName, (Resource)userResource);
                } else {
                    userResource = (Collection)this.registry.get("/users/" + userName);
                }
                if (!transactionStarted) {
                    this.registry.beginTransaction();
                }
                userResource.removeProperty("RememberMeToken");
                userResource.setProperty("RememberMeToken", value);
                this.registry.put("/users/" + userName, (Resource)userResource);
                if (!transactionStarted) {
                    this.registry.commitTransaction();
                }
            }
            catch (Exception ex) {
                if (transactionStarted) break block8;
                try {
                    this.registry.rollbackTransaction();
                }
                catch (RegistryException e) {
                    throw new Exception("Error occured while updating remember me token", e);
                }
            }
        }
    }

    public String getToken(String userName) throws Exception {
        Collection userResource = null;
        String value = null;
        try {
            if (!this.registry.resourceExists("/users/" + userName)) {
                return null;
            }
            userResource = (Collection)this.registry.get("/users/" + userName);
            value = userResource.getProperty("RememberMeToken");
        }
        catch (Exception e) {
            log.error((Object)"Error occured while updating remember me token", (Throwable)e);
            throw new RegistryException("Error occured while updating remember me token", (Throwable)e);
        }
        return value;
    }
}

