/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.core.rolesofuser;

import java.io.Serializable;
import org.wso2.carbon.caching.core.CacheKey;

public class UserRolesCacheKey
extends CacheKey
implements Serializable {
    private static final long serialVersionUID = 987045632165409867L;
    private String userName;
    private String serverId;
    private int tenantId;

    public UserRolesCacheKey(String serverId, int tenantId, String userName) {
        this.tenantId = tenantId;
        this.userName = userName;
        this.serverId = serverId;
    }

    @Override
    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof UserRolesCacheKey)) {
            return false;
        }
        UserRolesCacheKey userRolesCacheKey = (UserRolesCacheKey)otherObject;
        return this.checkKeyAttributesEqual(userRolesCacheKey.getServerId(), userRolesCacheKey.getTenantId(), userRolesCacheKey.getUserName());
    }

    @Override
    public int hashCode() {
        return this.getAttributeHashCode();
    }

    public boolean checkKeyAttributesEqual(String serverId, int tenantId, String userName) {
        if (this.serverId != null) {
            return this.tenantId == tenantId && this.userName.equals(userName) && this.serverId.equals(serverId);
        }
        return this.tenantId == tenantId && this.userName.equals(userName);
    }

    public int getAttributeHashCode() {
        if (this.serverId != null) {
            return (this.tenantId == -1234 ? 0 : this.tenantId) + this.userName.hashCode() * 7 + this.serverId.hashCode() * 11;
        }
        return (this.tenantId == -1234 ? 0 : this.tenantId) + this.userName.hashCode() * 7;
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getServerId() {
        return this.serverId;
    }
}

