/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.core.ehcache;

import net.sf.ehcache.CacheManager;
import net.sf.ehcache.jcache.JCache;
import net.sf.jsr107cache.Cache;
import net.sf.jsr107cache.CacheException;
import net.sf.jsr107cache.CacheFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.caching.core.CacheConfiguration;
import org.wso2.carbon.caching.core.CarbonCacheManager;

public class EhcacheManager
extends net.sf.jsr107cache.CacheManager
implements CarbonCacheManager {
    private static final Log log = LogFactory.getLog(EhcacheManager.class);
    private static Boolean lock = new Boolean(true);
    private long maxExpirationMillis = 0L;
    private long maxIdleExpirationMillis = 0L;
    private int maxEntries = 0;

    @Override
    public void initialize(String carbonHome) {
        CacheConfiguration cacheConfiguration = CacheConfiguration.getInstance();
        this.maxExpirationMillis = cacheConfiguration.getProperty("maxExpirationMillis") == null ? 900000L : Long.parseLong(cacheConfiguration.getProperty("maxExpirationMillis"));
        this.maxIdleExpirationMillis = cacheConfiguration.getProperty("maxIdleExpirationMillis") == null ? 900000L : Long.parseLong(cacheConfiguration.getProperty("maxIdleExpirationMillis"));
        int n = this.maxEntries = cacheConfiguration.getProperty("maxEntries") == null ? 5000 : Integer.parseInt(cacheConfiguration.getProperty("maxEntries"));
        if (log.isDebugEnabled()) {
            log.debug((Object)"cache manager initialized");
        }
    }

    @Override
    public String getDefaultCacheName() {
        return "___defaultcache";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cache getCache(String cacheName) {
        CacheManager manager;
        JCache cache;
        if (cacheName == null) {
            cacheName = "___defaultcache";
        }
        if ((cache = (manager = CacheManager.getInstance()).getJCache(cacheName)) == null) {
            Boolean bl = lock;
            synchronized (bl) {
                cache = manager.getJCache(cacheName);
                if (cache == null) {
                    net.sf.ehcache.config.CacheConfiguration cacheConfig = new net.sf.ehcache.config.CacheConfiguration();
                    cacheConfig.setDiskPersistent(false);
                    cacheConfig.setDiskSpoolBufferSizeMB(0);
                    cacheConfig.setOverflowToDisk(false);
                    cacheConfig.setTimeToIdleSeconds(this.maxIdleExpirationMillis / 1000L);
                    cacheConfig.setTimeToLiveSeconds(this.maxExpirationMillis / 1000L);
                    cacheConfig.setMaxElementsInMemory(this.maxEntries);
                    manager.addCache(cacheName);
                    cache = manager.getJCache(cacheName);
                }
            }
        }
        return cache;
    }

    @Override
    public CacheFactory getCacheFactory() throws CacheException {
        throw new CacheException("The EhcacheCacheManager does not provide an in-built nor look-up a CacheFactory.");
    }

    @Override
    public void registerCache(String cacheName, Cache cache) {
        throw new RuntimeException("The EhcacheCacheManager does not provide register.");
    }
}

