/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.core;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jsr107cache.Cache;
import net.sf.jsr107cache.CacheEntry;
import net.sf.jsr107cache.CacheException;
import net.sf.jsr107cache.CacheFactory;
import net.sf.jsr107cache.CacheListener;
import net.sf.jsr107cache.CacheStatistics;
import org.wso2.carbon.caching.core.CarbonCacheManager;

public class InMemoryCacheManager
implements CarbonCacheManager {
    private final Map<String, Cache> caches = Collections.synchronizedMap(new HashMap());

    @Override
    public void initialize(String carbonHome) {
    }

    @Override
    public String getDefaultCacheName() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cache getCache(String cacheName) {
        Cache cache = this.caches.get(cacheName);
        if (cache == null) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(InMemoryCacheManager.class.getClassLoader());
                cache = new InMemoryJCacheWrapper(new ConcurrentHashMap<Object, Object>());
                this.registerCache(cacheName, cache);
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
        return cache;
    }

    public Cache getDistributedCacheWithMode(String cacheName, String cacheModeString, boolean isSync, boolean fallBackToDefault) {
        return this.getCache(cacheName);
    }

    public Cache getLocalCache(String cacheName) {
        return this.getCache(cacheName);
    }

    @Override
    public void registerCache(String cacheName, Cache cache) {
        if (cache == null) {
            this.caches.remove(cacheName);
        } else if (this.caches.get(cacheName) == null) {
            this.caches.put(cacheName, cache);
        }
    }

    @Override
    public CacheFactory getCacheFactory() throws CacheException {
        throw new CacheException("The InMemoryCacheManager does not provide an in-built nor look-up a CacheFactory.");
    }

    private static class InMemoryJCacheWrapper
    implements Cache {
        private Map<Object, Object> cache;

        public InMemoryJCacheWrapper(Map<Object, Object> cache) {
            this.cache = cache;
        }

        public boolean containsKey(Object o) {
            return this.cache.containsKey(o);
        }

        public boolean containsValue(Object o) {
            return this.cache.containsValue(o);
        }

        public Set entrySet() {
            return this.cache.entrySet();
        }

        public boolean equals(Object o) {
            return o instanceof InMemoryJCacheWrapper && ((Object)((InMemoryJCacheWrapper)o).cache).equals(this.cache);
        }

        public int hashCode() {
            return (int)((long)((Object)this.cache).hashCode() + (long)this.getClass().getCanonicalName().hashCode());
        }

        public boolean isEmpty() {
            return this.cache.isEmpty();
        }

        public Set keySet() {
            return this.cache.keySet();
        }

        public void putAll(Map map) {
            this.cache.putAll(map);
        }

        public int size() {
            return this.cache.size();
        }

        public Collection values() {
            return this.cache.values();
        }

        public Object get(Object o) {
            return this.cache.get(o);
        }

        public Map getAll(Collection collection) throws CacheException {
            ConcurrentHashMap output = new ConcurrentHashMap();
            for (Object o : collection) {
                output.put(o, this.get(o));
            }
            return output;
        }

        public void load(Object o) throws CacheException {
        }

        public void loadAll(Collection collection) throws CacheException {
            for (Object o : collection) {
                this.load(o);
            }
        }

        public Object peek(Object o) {
            return this.cache.entrySet().isEmpty() ? null : this.cache.entrySet().iterator().next();
        }

        public Object put(Object o, Object o1) {
            return this.cache.put(o, o1);
        }

        public CacheEntry getCacheEntry(Object o) {
            return new InMemoryJCacheEntry(o, this.cache.get(o));
        }

        public CacheStatistics getCacheStatistics() {
            throw new UnsupportedOperationException("The InMemoryCacheManager does not provide statistics.");
        }

        public Object remove(Object o) {
            return this.cache.remove(o);
        }

        public void clear() {
            this.cache.clear();
        }

        public void evict() {
        }

        public void addListener(CacheListener cacheListener) {
        }

        public void removeListener(CacheListener cacheListener) {
        }
    }

    private static class InMemoryJCacheEntry
    implements CacheEntry {
        private Object key;
        private Object value;
        long createdTime;

        private InMemoryJCacheEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
            this.createdTime = new Date().getTime();
        }

        public int getHits() {
            throw new UnsupportedOperationException("The In-memory cache manager does not allow to find the number of hits on a per-entry basis.");
        }

        public long getLastAccessTime() {
            throw new UnsupportedOperationException("The In-memory cache manager does not provide timing details.");
        }

        public long getLastUpdateTime() {
            throw new UnsupportedOperationException("The In-memory cache manager does not provide timing details.");
        }

        public long getCreationTime() {
            return this.createdTime;
        }

        public long getExpirationTime() {
            throw new UnsupportedOperationException("The In-memory cache manager does not provide timing details.");
        }

        public long getVersion() {
            return this.createdTime;
        }

        public boolean isValid() {
            return true;
        }

        public long getCost() {
            return 0L;
        }

        public Object getKey() {
            return this.key != null ? this.key : null;
        }

        public Object getValue() {
            return this.value != null ? this.value : null;
        }

        public Object setValue(Object o) {
            if (this.key != null) {
                this.value = o;
                return o;
            }
            return null;
        }
    }
}

