/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.wsdl20.validation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.woden.WSDLException;
import org.apache.woden.internal.WSDLContext;
import org.apache.woden.internal.wsdl20.assertions.Description1001;
import org.apache.woden.internal.wsdl20.assertions.Description1002;
import org.apache.woden.internal.wsdl20.assertions.Interface1009;
import org.apache.woden.internal.wsdl20.assertions.Interface1010;
import org.apache.woden.internal.wsdl20.validation.WodenContextImpl;
import org.apache.woden.wsdl20.Description;
import org.apache.woden.wsdl20.Interface;
import org.apache.woden.wsdl20.validation.Assertion;
import org.apache.woden.wsdl20.validation.AssertionInfo;
import org.apache.woden.wsdl20.validation.WodenContext;
import org.apache.woden.wsdl20.xml.DescriptionElement;

public class WSDLValidator {
    private WSDLContext fWsdlCtx;
    private WodenContext fWodenCtx;
    private Map fWsdlAsserts;
    private Map fExtAsserts;

    public void validate(Description description, WSDLContext wsdlContext) throws WSDLException {
        int len = 0;
        this.fWsdlCtx = wsdlContext;
        this.fWodenCtx = new WodenContextImpl(this.fWsdlCtx.errorReporter, this.fWsdlCtx.uriResolver);
        this.setupWSDLAssertions();
        this.setupExtensionAssertions();
        DescriptionElement descElem = description.toElement();
        this.checkAssertions(DescriptionElement.class, descElem);
        this.checkAssertions(Description.class, description);
        Interface[] intfaces = description.getInterfaces();
        len = intfaces.length;
        for (int i = 0; i < len; ++i) {
            this.checkAssertions(class$org$apache$woden$wsdl20$Interface == null ? WSDLValidator.class$("org.apache.woden.wsdl20.Interface") : class$org$apache$woden$wsdl20$Interface, intfaces[i]);
        }
    }

    private void checkAssertions(Class targetClass, Object target) throws WSDLException {
        List extAsserts;
        Assertion a = null;
        List wsdlAsserts = (List)this.fWsdlAsserts.get(targetClass);
        if (wsdlAsserts != null) {
            Iterator i = wsdlAsserts.iterator();
            while (i.hasNext()) {
                a = (Assertion)i.next();
                a.validate(target, this.fWodenCtx);
            }
        }
        if ((extAsserts = (List)this.fExtAsserts.get(targetClass)) != null) {
            Iterator i = extAsserts.iterator();
            while (i.hasNext()) {
                a = (Assertion)i.next();
                a.validate(target, this.fWodenCtx);
            }
        }
    }

    private void setupWSDLAssertions() {
        this.fWsdlAsserts = new HashMap();
        Vector<Assertion> descElem = new Vector<Assertion>();
        descElem.add(new Description1001());
        descElem.add(new Description1002());
        descElem.add(new Description1002());
        this.fWsdlAsserts.put(DescriptionElement.class, descElem);
        Vector<Interface1010> desc = new Vector<Interface1010>();
        desc.add(new Interface1010());
        this.fWsdlAsserts.put(Description.class, desc);
        Vector<Interface1009> intf = new Vector<Interface1009>();
        intf.add(new Interface1009());
        this.fWsdlAsserts.put(Interface.class, intf);
    }

    private void setupExtensionAssertions() {
        this.fExtAsserts = new HashMap();
        AssertionInfo[] infos = this.fWsdlCtx.extensionRegistry.queryAssertions();
        int len = infos.length;
        for (int i = 0; i < len; ++i) {
            Class target = infos[i].targetClass;
            Vector<Assertion> asserts = (Vector<Assertion>)this.fExtAsserts.get(target);
            if (asserts == null) {
                asserts = new Vector<Assertion>();
            }
            asserts.add(infos[i].assertion);
            this.fExtAsserts.put(target, asserts);
        }
    }
}

