/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.transaction.context;

import java.util.concurrent.Callable;
import org.compass.core.CompassException;
import org.compass.core.transaction.InternalCompassTransaction;
import org.compass.core.transaction.TransactionException;
import org.compass.core.transaction.context.TransactionContext;
import org.compass.core.transaction.context.TransactionContextCallbackWithTr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionalCallableWithTr<T>
implements Callable<T> {
    private TransactionContext transactionContext;
    private Callable<T> delegate;

    public TransactionalCallableWithTr(TransactionContext transactionContext, Callable<T> delegate) {
        this.transactionContext = transactionContext;
        this.delegate = delegate;
    }

    @Override
    public T call() throws Exception {
        return this.transactionContext.execute(new TransactionContextCallbackWithTr<T>(){

            @Override
            public T doInTransaction(InternalCompassTransaction tr) throws CompassException {
                try {
                    return TransactionalCallableWithTr.this.delegate.call();
                }
                catch (Exception e) {
                    throw new TransactionException("Failed to execute callable", e);
                }
            }
        });
    }
}

