/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing;

import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.WaitBeforeShutdownObserver;

public class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);
    private static RegistryService registryService;
    private static List<WaitBeforeShutdownObserver> waitBeforeShutdownObserver;
    private static String defaultEventingServiceURL;
    private static String remoteTopicHeaderName;
    private static String remoteTopicHeaderNS;
    private static String remoteSubscriptionStoreContext;

    public static synchronized void setRegistryService(RegistryService service) {
        registryService = service;
    }

    public static synchronized RegistryService getRegistryService() {
        return registryService;
    }

    public static WaitBeforeShutdownObserver[] getWaitBeforeShutdownObservers() {
        return waitBeforeShutdownObserver.toArray(new WaitBeforeShutdownObserver[waitBeforeShutdownObserver.size()]);
    }

    public static void setWaitBeforeShutdownObserver(WaitBeforeShutdownObserver service) {
        CarbonUtils.checkSecurity();
        waitBeforeShutdownObserver.add(service);
    }

    public static void clearWaitBeforeShutdownObserver() {
        CarbonUtils.checkSecurity();
        waitBeforeShutdownObserver = new LinkedList<WaitBeforeShutdownObserver>();
    }

    public static Registry getRegistry() throws RegistryException {
        MessageContext messageContext = MessageContext.getCurrentMessageContext();
        if (messageContext == null) {
            String msg = "Could not get the user's Registry session. Message context not found.";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        HttpServletRequest request = (HttpServletRequest)messageContext.getProperty("transport.http.servletRequest");
        Registry registry = (Registry)request.getSession().getAttribute("user_registry");
        if (registry == null) {
            String msg = "User's Registry instance is not found. Creating a anonymous Registry instance for the user.";
            if (log.isDebugEnabled()) {
                log.debug((Object)msg);
            }
            if (registryService == null) {
                msg = "Unable to create anonymous Registry instance for user. Registry Service was not found.";
                log.error((Object)msg);
                throw new RegistryException(msg);
            }
            registry = registryService.getUserRegistry();
            request.getSession().setAttribute("user_registry", (Object)registry);
        }
        return registry;
    }

    public static String getDefaultEventingServiceURL() {
        return defaultEventingServiceURL;
    }

    public static void setDefaultEventingServiceURL(String defaultEventingServiceURL) {
        Utils.defaultEventingServiceURL = defaultEventingServiceURL;
    }

    public static String getRemoteTopicHeaderName() {
        return remoteTopicHeaderName;
    }

    public static void setRemoteTopicHeaderName(String remoteTopicHeaderName) {
        Utils.remoteTopicHeaderName = remoteTopicHeaderName;
    }

    public static String getRemoteTopicHeaderNS() {
        return remoteTopicHeaderNS;
    }

    public static void setRemoteTopicHeaderNS(String remoteTopicHeaderNS) {
        Utils.remoteTopicHeaderNS = remoteTopicHeaderNS;
    }

    public static String getRemoteSubscriptionStoreContext() {
        return remoteSubscriptionStoreContext;
    }

    public static void setRemoteSubscriptionStoreContext(String remoteSubscriptionStoreContext) {
        Utils.remoteSubscriptionStoreContext = remoteSubscriptionStoreContext;
    }

    static {
        waitBeforeShutdownObserver = new LinkedList<WaitBeforeShutdownObserver>();
    }
}

