/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.bulkimport;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.mgt.bulkimport.BulkImportConfig;
import org.wso2.carbon.user.mgt.common.UserAdminException;

public class CSVUserBulkImport {
    private static Log log = LogFactory.getLog(CSVUserBulkImport.class);
    private BufferedReader reader;
    private BulkImportConfig config;

    public CSVUserBulkImport(BulkImportConfig config) {
        this.config = config;
        this.reader = new BufferedReader(new InputStreamReader(config.getInStream()));
    }

    public void addUserList(UserStoreManager userStore) throws UserAdminException {
        try {
            CSVReader csvReader = new CSVReader((Reader)this.reader, ',', '\"', 1);
            String password = this.config.getDefaultPassword();
            String[] line = csvReader.readNext();
            boolean isDuplicate = false;
            while (line != null && line.length > 0) {
                String userName = line[0];
                if (!userStore.isExistingUser(userName)) {
                    userStore.addUser(userName, (Object)password, null, null, null, true);
                } else {
                    isDuplicate = true;
                }
                line = csvReader.readNext();
            }
            if (isDuplicate) {
                throw new UserAdminException("Detected duplicate usernames. Failed to import duplicate users. Non-duplicate user names were successfually imported.");
            }
        }
        catch (UserAdminException e) {
            throw e;
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }
}

