/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.ext.internal;

import java.io.File;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.connector.Request;
import org.wso2.carbon.tomcat.ext.utils.URLMappingHolder;
import org.wso2.carbon.utils.CarbonUtils;

public class Utils {
    private static final String WEB_APP_PATTERN = "/webapps/";
    private static final String JAGGERY_APP_PATTERN = "/jaggeryapps/";
    private static final String JAX_APP_PATTERN = "/jaxwebapps/";

    public static String getTenantDomain(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        String domain = "carbon.super";
        if (!requestURI.contains("/t/")) {
            HttpSession session = request.getSession(false);
            if (session != null && session.getAttribute("tenantDomain") != null) {
                domain = (String)session.getAttribute("tenantDomain");
            }
        } else {
            String temp = requestURI.substring(requestURI.indexOf("/t/") + 3);
            if (temp.indexOf(47) != -1) {
                domain = temp = temp.substring(0, temp.indexOf(47));
            }
        }
        return domain;
    }

    public static String getServiceName(String requestURI) {
        String serviceName = "";
        if (requestURI.contains("/services/")) {
            String[] temp2;
            String temp = requestURI.substring(requestURI.indexOf("/services/") + 9);
            if (temp.indexOf(47) != -1) {
                serviceName = temp = temp.substring(0, temp.length());
            }
            if (serviceName.contains("/t/") && (temp2 = serviceName.split("/")).length > 3) {
                serviceName = temp2[3];
            }
            if (serviceName.contains(".")) {
                serviceName = serviceName.substring(0, serviceName.indexOf(46));
            } else if (serviceName.contains("?")) {
                serviceName = serviceName.substring(0, serviceName.indexOf(63));
            }
        }
        serviceName = serviceName.substring(serviceName.indexOf(47) + 1, serviceName.length());
        return serviceName;
    }

    public static String getAppNameFromRequest(Request request) {
        String appName = null;
        String uri = request.getRequestURI();
        String temp = null;
        if (uri.startsWith("/services/")) {
            return Utils.getServiceName(uri);
        }
        if (uri.contains(WEB_APP_PATTERN)) {
            temp = uri.substring(uri.indexOf(WEB_APP_PATTERN) + 9);
        } else if (uri.contains(JAGGERY_APP_PATTERN)) {
            temp = uri.substring(uri.indexOf(JAGGERY_APP_PATTERN) + 13);
        } else if (uri.contains(JAX_APP_PATTERN)) {
            temp = uri.substring(uri.indexOf(JAX_APP_PATTERN) + 12);
        } else {
            appName = request.getContext().getName();
            if (!appName.equals("/")) {
                return appName.substring(1);
            }
            return null;
        }
        appName = temp.contains("/") ? temp.substring(0, temp.indexOf("/")) : temp;
        return appName;
    }

    public static File createDummyTenantContextDir() {
        File dummyCtxFile = new File(CarbonUtils.getTmpDir() + File.separator + "t");
        if (!dummyCtxFile.exists() && !dummyCtxFile.mkdir()) {
            return null;
        }
        return dummyCtxFile;
    }

    public static String getTenantDomainFromURLMapping(Request request) {
        String requestURI = request.getRequestURI();
        String domain = "carbon.super";
        String serverName = request.getHost().getName();
        String appContext = URLMappingHolder.getInstance().getApplicationFromUrlMapping(serverName);
        if (appContext != null) {
            requestURI = appContext;
        }
        if (!requestURI.contains("/t/")) {
            HttpSession session = request.getSession(false);
            if (session != null && session.getAttribute("tenantDomain") != null) {
                domain = (String)session.getAttribute("tenantDomain");
            }
        } else {
            String temp = requestURI.substring(requestURI.indexOf("/t/") + 3);
            if (temp.indexOf(47) != -1) {
                domain = temp = temp.substring(0, temp.indexOf(47));
            }
        }
        return domain;
    }

    public static String getAppNameForURLMapping(Request request) {
        String appName = null;
        String temp = null;
        String hostName = request.getHost().getName();
        String uri = URLMappingHolder.getInstance().getApplicationFromUrlMapping(hostName);
        if (uri != null) {
            if (uri.startsWith("/services/")) {
                appName = Utils.getServiceName(uri);
            } else {
                temp = uri.contains(WEB_APP_PATTERN) ? uri.substring(uri.indexOf(WEB_APP_PATTERN) + 9) : (uri.contains(JAGGERY_APP_PATTERN) ? uri.substring(uri.indexOf(JAGGERY_APP_PATTERN) + 13) : (uri.contains(JAX_APP_PATTERN) ? uri.substring(uri.indexOf(JAX_APP_PATTERN) + 12) : uri.substring(1)));
            }
            appName = temp.endsWith("/") ? temp.substring(0, temp.indexOf("/")) : temp;
        }
        return appName;
    }
}

